<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * 
 */
class GetFinancialFlowsListResponseFinancialFlow
{
	
	/**
	 * Дата финансового потока (формат yyyy-mm)
	 * Financial flow date in the following format: yyyy-mm
	 * 
	 *
	 * @var string
	 */
	 public $date = null;

	/**
	 * Есть ли доступ к финансовому потоку плательщика.
	 * Indicates whether the user has access to the payer's financial flow information.
	 * Valid values are:
	 * true. The user has access to the payer's financial flow information.
	 * false. The user does not have access to the payer's financial flow information.
	 * 
	 *
	 * @var boolean
	 */
	 public $payerSideAccess = null;

	/**
	 * ID финансового потока плательщика.
	 * Financial flow ID of the payer.
	 * 
	 *
	 * @var long
	 */
	 public $payerFlowId = null;

	/**
	 * Название финансового потока плательщика.
	 * The name of the payer's financial flow.
	 * 
	 *
	 * @var string
	 */
	 public $payerFlowName = null;

	/**
	 * Валюта финансового потока плательщика.
	 * The currency of the payer's financial flow.
	 * 
	 *
	 * @var string
	 */
	 public $payerCurrencyCode = null;

	/**
	 * Есть ли доступ к финансовому потоку получателя.
	 * Indicates whether the user has access to the payee's financial flow.
	 * 
	 *
	 * @var boolean
	 */
	 public $payeeSideAccess = null;

	/**
	 * ID финансового потока получателя.
	 * Payee's financial flow ID.
	 * 
	 *
	 * @var long
	 */
	 public $payeeFlowId = null;

	/**
	 * Название финансового потока получателя.
	 * Payee's financial flow name.
	 * 
	 *
	 * @var string
	 */
	 public $payeeFlowName = null;

	/**
	 * Валюта финансового потока получателя.
	 * The currency of the payee's financial flow.
	 * 
	 *
	 * @var string
	 */
	 public $payeeCurrencyCode = null;

	/**
	 * Сумма, списанная с плательщика.
	 * The transaction amount that was debited from the payer's account.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerDebited = null;

	/**
	 * Сумма, удержанная с плательщика.
	 * Withheld amount from the payer's account.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerWithheld = null;

	/**
	 * Сумма комиссии плательщика.
	 * Payer's transaction fee.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerFee = null;

	/**
	 * Сумма обменной комиссии плательщика.
	 * Exchange fee for the payer.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerExchangeFee = null;

	/**
	 * Сумма, зачисленная получателю.
	 * Transaction amount that is transferred to the payee's account.
	 * 
	 *
	 * @var decimal
	 */
	 public $payeeCredited = null;

	/**
	 * Сумма комисии получателя.
	 * Payee's transaction fee.
	 * 
	 *
	 * @var decimal
	 */
	 public $payeeFee = null;

	/**
	 * Количество операций в данном финансовом потоке.
	 * The number of transactions in a financial flow.
	 * 
	 *
	 * @var long
	 */
	 public $transactionsCount = null;

	/**
	 * Категория операций в данном финансовом потоке (возвращается, если в запросе categoryDetails=true).
	 * If the request set the categoryDetails element to true, specifies transaction categories that are included into this response.
	 * 
	 *
	 * @var string
	 */
	 public $operationTypeCategory = null;

	/**
	 * Состояние операций в данном финансовом потоке.
	 * Statuses of transactions that are included into the financial flow.
	 * 
	 *
	 * @var string
	 */
	 public $operationStatusState = null;

	/**
	 * false - Обычные проводки.
	 * true - Сторнирующие проводки.
	 * Для получения этого поля в запросе необходимо выставлять атрибут version равный или больше VERSION_2.
	 * false - Normal postings.
	 * true - Reversal postings.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_2 or higher.
	 * 
	 *
	 * @var boolean
	 */
	 public $reversal = null;

	/**
	 * Дополнительные атрибуты ответа.
	 * Для получения этого поля в запросе необходимо выставлять атрибут version равный или больше VERSION_2.
	 * Additional response parameters.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_2 or higher.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $attribute = null;

	/**
	 * Дополнительные атрибуты ответа.
	 * Для получения этого поля в запросе необходимо выставлять атрибут version равный или больше VERSION_2.
	 * Additional response parameters.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_2 or higher.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAttribute(KeyValueAttribute $item)
	{
		$this->attribute[] = $item;
	}

}
