<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Ответ, который приходит на запрос FindProfileInfoRequest.
	 * Данные в ответе разбиты по страницам.
	 * Если данные не найдены, то size в ответе равен 0.
	 * Response to FindProfileInfoRequest.
	 * The response might contain multiple pages.
	 * If the size element of the response is set to 0, MONETA.RU found no data.
	 * 
 */
class FindProfileInfoResponse
{
	
	/**
	 * Количество пользователей, возвращаемых в результате запроса.
	 * Specifies the number of profile to return per page.
	 * 
	 *
	 * @var long
	 */
	 public $pageSize = null;

	/**
	 * Номер текущей страницы. Нумерация начинается с 1.
	 * The current page number. Page numbering starts from 1.
	 * 
	 *
	 * @var long
	 */
	 public $pageNumber = null;

	/**
	 * Сколько всего страниц с пользователями возможно по данному запросу.
	 * Total number of pages in the response.
	 * 
	 *
	 * @var long
	 */
	 public $pagesCount = null;

	/**
	 * Размер текущей страницы. Он всегда <= pageSize. На последней странице может быть < pageSize.
	 * The number of profiles on the current page.
	 * 
	 *
	 * @var long
	 */
	 public $size = null;

	/**
	 * Общее количество пользователей, которое можно получить в данной выборке.
	 * The total number of profiles in the response.
	 * 
	 *
	 * @var long
	 */
	 public $totalSize = null;

	/**
	 * Список пользователей.
	 * The list of profiles.
	 * 
	 *
	 * @var Profile
	 */
	 public $profile = null;

	/**
	 * Список пользователей.
	 * The list of profiles.
	 * 
	 *
	 * @param Profile
	 *
	 * @return void
	 */
	public function addProfile(Profile $item)
	{
		$this->profile[] = $item;
	}

}
