<?php

global $tpl;
global $messages;
global $PI;

if(page()->privacy == 1 && !is_auth()) {
	show_error_page('not_auth');
}

$number = getPageParam('page');
$limit  = getLimit('stats_lim');
$start  = getPageStartPosition($number, $limit);
$serverId = getPageParam('server');

$isHasRank = 0;
$count = 0;

$statisticsService = new GameCMS\Services\StatisticsService();

if($serverId) {
	$server = \GameCMS\Repositories\ServerRepository::getById($serverId);
	if(empty($server)) {
		show_error_page('servers_not_configured');
	}

	$integrator = $statisticsService->getIntegrator($server->st_type);
	if($integrator->isBlank()) {
		show_error_page('servers_not_configured');
	}
} else {
	$servers = \GameCMS\Repositories\ServerRepository::getAll();
	foreach($servers as $serverItem) {
		$integrator = $statisticsService->getIntegrator($serverItem->st_type);
		if(!$integrator->isBlank()) {
			$server = $serverItem;
			break;
		}
	}
}

if(empty($server)) {
	show_error_page('servers_not_configured');
}

$page_name = "../stats?server={$server->id}&";

[$connection, $error] = $integrator->getStorageConnection($server);
if($error) {
	$error = $messages['errorConnectingToDatabase'];
} else {
	$count = $integrator->getStatsCount($server, $connection);
	$isHasRank = $integrator->isHasRank($server, $connection);
}

resetIfPaginationIncorrect($number, $limit, $count, '../stats');

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", page()->title);
$tpl->set("{name}", configs()->name);
$tpl->compile('title');
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title'], false);
$tpl->set("{site_name}", configs()->name);
$tpl->set("{image}", page()->image);
$tpl->set("{robots}", page()->robots);
$tpl->set("{type}", page()->kind);
$tpl->set("{description}", page()->description);
$tpl->set("{keywords}", page()->keywords);
$tpl->set("{url}", page()->url);
$tpl->set("{other}", '');
$tpl->set("{token}", token());
$tpl->set("{cache}", configs()->cache);
$tpl->set("{template}", get_template());
$tpl->compile('content');
$tpl->clear();

$menu = $tpl->get_menu();

$nav = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('stats', 1, 0)
];
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

if(is_auth()) {
	include_once __DIR__ . '/../../inc/authorized.php';
} else {
	include_once __DIR__ . '/../../inc/not_authorized.php';
}

$tpl->result['categories'] = '';

foreach(GameCMS\Repositories\ServerRepository::getAll() as $serverItem) {
	if(!$statisticsService->getIntegrator($serverItem->st_type)->isBlank()) {
		tpl()->compileCategory(
			$serverItem->name,
			'../stats?server=' . $serverItem->id,
			$serverItem->id == $server->id,
			'stats'
		);
	}
}

$tpl->load_template('/home/stats.tpl');
$tpl->set("{template}", get_template());
$tpl->set("{start}", $start);
$tpl->set("{limit}", $limit);
$tpl->set("{server}", $server->id);
$tpl->set("{error}", $error ?? '');
$tpl->set("{servers}", $tpl->result['categories'], false);
$tpl->set("{type}", $server->st_type);
$tpl->set("{isHasRank}", $isHasRank);
$tpl->set("{pagination}", $tpl->paginator($number, $count, $limit, $page_name));
$tpl->compile('content');
$tpl->clear();