<?php

use GameCMS\Services\SteamApi\Authorization as SteamAuthorization;
use GameCMS\Services\VkApi\Authorization as VkAuthorization;

if (!is_auth()) {
    show_error_page('not_auth');
}

global $auth_api, $full_site_host, $SC, $messages, $tpl, $user, $PI;

$AA = new AuthApi();
$pages_urls = $AA->redirectPage();

$vk_attach_result = '';
if ($auth_api->vk_api == 1 && isset($_GET['code']) && empty($_GET['fb_attach'])) {
    $vkAuthorization = new VkAuthorization($auth_api->vk_id, configs()->vk_api_version, getVkApiTimeout());

    [$vkUserInfo, $error] = $vkAuthorization->authorize(
        $_GET['code'],
        $_GET['state'],
        $_GET['device_id'],
        $full_site_host.$pages_urls['settings'],
    );
    if ($error) {
        log_error('vk-attach: '.$error);
    } elseif ($vkUserInfo->data == md5($SC->set_token())) {
        $vk_id = $vkUserInfo->user_id;
        $STH = pdo()->prepare('SELECT id, avatar FROM users WHERE vk_api=:vk_api LIMIT 1');
        $STH->execute([':vk_api' => $vk_id]);
        $row = $STH->fetchObject();
        if (empty($row->id) && $AA->isAttachCacheCorrect($user->password)) {
            $avatar = user()->avatar;

            if ($avatar == 'files/avatars/no_avatar.jpg' && $vkUserInfo->has_photo) {
                $avatar = downloadUserAvatar($vkUserInfo->photo);
            }

            $STH = pdo()->prepare('UPDATE users SET vk_api=:vk_api, avatar=:avatar, vk=:vk WHERE id=:id LIMIT 1');
            $STH->execute(
                [
                    ':vk_api' => $vk_id,
                    ':avatar' => $avatar,
                    ':vk' => 'id'.$vk_id,
                    ':id' => $_SESSION['id'],
                ]
            );

            header('Location: ../settings#vk_area');

            exit;
        }
    }

    $vk_attach_result = '<span class="m-icon icon-remove"></span> '.$messages['Error'];
}

$steam_attach_result = '';
if ($auth_api->steam_api == 1 && isset($_GET['steam_attach'])) {
    $steamAuthorization = new SteamAuthorization(
        $full_site_host,
        $auth_api->steam_key,
        getSteamApiTimeout()
    );

    [$steamUserInfo, $error] = $steamAuthorization->authorize($_GET['state']);
    if ($error) {
        log_error('steam-attach: '.$error);
    } elseif ($steamUserInfo->data == md5($SC->set_token())) {
        $STH = pdo()->prepare('SELECT id, avatar, steam_id, nick FROM users WHERE steam_api=:steam_api LIMIT 1');
        $STH->execute([':steam_api' => $steamUserInfo->steamId]);
        $row = $STH->fetchObject();
        if (empty($row->id) && $AA->isAttachCacheCorrect($user->password)) {
            $user_info = [];
            $user_info['id'] = user()->id;
            $user_info['steam_api'] = $steamUserInfo->steamId;
            $user_info['avatar'] = user()->avatar;
            $user_info['steam_id'] = user()->steam_id;
            $user_info['nick'] = user()->nick;

            if ($user_info['avatar'] == 'files/avatars/no_avatar.jpg') {
                $user_info['avatar'] = downloadUserAvatar(clean($steamUserInfo->avatar));
            }

            if (empty($user_info['steam_id']) && configsSecondary()->auto_steam_id_fill) {
                $user_info['steam_id'] = (new SteamIDOperations())->GetSteamID32($steamUserInfo->steamId);
            }

            if (empty($user_info['nick'])) {
                $user_info['nick'] = clean($steamUserInfo->login);
            }

            $STH = pdo()->prepare(
                'UPDATE users SET steam_api=:steam_api, avatar=:avatar, steam_id=:steam_id, nick=:nick WHERE id=:id LIMIT 1'
            );
            $STH->execute($user_info);

            header('Location: ../settings#steam_area');

            exit;
        }
    }

    $steam_attach_result = '<span class="m-icon icon-remove"></span> '.$messages['Error'];
}

$fb_attach_result = '';
if ($auth_api->fb_api == 1 && isset($_GET['code'], $_GET['fb_attach'])) {
    $params = [
        'client_id' => $auth_api->fb_id,
        'redirect_uri' => $full_site_host.$pages_urls['settings'].'?fb_attach=1',
        'client_secret' => $auth_api->fb_key,
        'code' => $_GET['code'],
    ];

    $fb_token = json_decode(
        file_get_contents_curl('https://graph.facebook.com/oauth/access_token?'.http_build_query($params)),
        true
    );

    if (isset($fb_token['access_token'])) {
        $params = ['access_token' => $fb_token['access_token']];
        $userInfo = json_decode(
            file_get_contents_curl('https://graph.facebook.com/me?'.urldecode(http_build_query($params))),
            true
        );
    }

    if (!empty($userInfo) && !empty($userInfo['id']) && $_GET['state'] == md5($SC->set_token())) {
        $fb_api = $userInfo['id'];
        $STH = pdo()->prepare('SELECT id FROM users WHERE fb_api=:fb_api LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':fb_api' => $fb_api]);
        $row = $STH->fetch();
        if (empty($row->id) && $AA->isAttachCacheCorrect($user->password)) {
            $STH = pdo()->prepare('UPDATE users SET fb_api=:fb_api WHERE id=:id LIMIT 1');
            $STH->execute([':fb_api' => $fb_api, ':id' => $_SESSION['id']]);
            header('Location: ../settings#fb_area');

            exit;
        }
    }

    $fb_attach_result = '<span class="m-icon icon-remove"></span> '.$messages['Error'];
}

$tpl->load_template('elements/title.tpl');
$tpl->set('{title}', page()->title);
$tpl->set('{name}', configs()->name);
$tpl->compile('title');
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set('{title}', $tpl->result['title'], false);
$tpl->set('{site_name}', configs()->name);
$tpl->set('{image}', page()->image);
$tpl->set('{robots}', page()->robots);
$tpl->set('{type}', page()->kind);
$tpl->set('{description}', page()->description);
$tpl->set('{keywords}', page()->keywords);
$tpl->set('{url}', page()->url);
$tpl->set('{other}', getLibAssets('tinymce'));
$tpl->set('{token}', token());
$tpl->set('{cache}', configs()->cache);
$tpl->set('{template}', get_template());
$tpl->compile('content');
$tpl->clear();

$menu = $tpl->get_menu();

$nav = [
    $PI->to_nav('main', 0, 0),
    $PI->to_nav('users', 0, 0),
    $PI->to_nav('profile', 0, $_SESSION['id'], $user->login),
    $PI->to_nav('settings', 1, 0),
];
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

include_once __DIR__.'/../../inc/authorized.php';

$STH = pdo()->query('SELECT `referral_program`, `referral_percent` FROM `config__prices` LIMIT 1');
$STH->setFetchMode(PDO::FETCH_OBJ);
$ref = $STH->fetch();

if (empty($user->signature)) {
    $user->signature = '';
}
if (empty($user->fb)) {
    $user->fb = 0;
}
if (empty($user->fb_api)) {
    $user->fb_api = 0;
}

if (substr($user->password, 0, 5) == 'none_') {
    $user->password = 'none';
}

$editor_settings = get_editor_settings();
$tpl->load_template('/home/settings.tpl');
$tpl->set('{file_manager}', $editor_settings['file_manager']);
$tpl->set('{file_manager_theme}', $editor_settings['file_manager_theme']);
$tpl->set('{token}', token());
$tpl->set('{template}', get_template());
$tpl->set('{referral_link}', $full_site_host.'?ref='.$_SESSION['id']);
$tpl->set('{profileLink}', $full_site_host.PagesInfo::PROFILE_PAGE_URL.'/');
$tpl->set('{referral_program}', $ref->referral_program);
$tpl->set('{referral_percent}', $ref->referral_percent);
$tpl->set('{login}', $user->login);
$tpl->set('{route}', $user->route);
$tpl->set('{avatar}', $user->avatar);
$tpl->set('{regdate}', expand_date($user->regdate, 2));
$tpl->set('{name}', $user->name);
$tpl->set('{nick}', $user->nick);
$tpl->set('{skype}', $user->skype);
$tpl->set('{discord}', $user->discord);
$tpl->set('{vk}', $user->vk);
$tpl->set('{vk_api}', $user->vk_api);
$tpl->set('{fb}', $user->fb);
$tpl->set('{fb_api}', $user->fb_api);
$tpl->set('{signature}', $user->signature);
$tpl->set('{steam_id}', $user->steam_id);
$tpl->set('{steam_api}', $user->steam_api);
$tpl->set('{telegram}', $user->telegram);
$birth = explode('-', $user->birth);
$birth_day = '';
for ($x = 31; $x > 0; --$x) {
    $birth_day = $birth_day.'<option value="'.$x.'" ';
    if ($birth[2] == $x) {
        $birth_day = $birth_day.' selected';
    }
    $birth_day = $birth_day.'>'.$x.'</option>';
}

$birth_month = '';
for ($x = 12; $x > 0; --$x) {
    $birth_month = $birth_month.'<option value="'.$x.'" ';
    if ($birth[1] == $x) {
        $birth_month = $birth_month.' selected';
    }
    $birth_month = $birth_month.'>'.get_month($x).'</option>';
}

$birth_year = '';
for ($x = date('Y'); $x > 1959; --$x) {
    $birth_year = $birth_year.'<option value="'.$x.'" ';
    if ($birth[0] == $x) {
        $birth_year = $birth_year.' selected';
    }
    $birth_year = $birth_year.'>'.$x.'</option>';
}

$tpl->set('{birth_day}', $birth_day);
$tpl->set('{birth_month}', $birth_month);
$tpl->set('{birth_year}', $birth_year);

$act = get_active($user->im, 2);
$tpl->set('{im_radio_1}', $act[0]);
$tpl->set('{im_radio_2}', $act[1]);

$act = get_active($user->protect, 2);
$tpl->set('{protect_radio_1}', $act[0]);
$tpl->set('{protect_radio_2}', $act[1]);

$act = get_active($user->email_notice, 2);
$tpl->set('{notice_radio_1}', $act[0]);
$tpl->set('{notice_radio_2}', $act[1]);

$tpl->set('{conf_mess}', $vk_attach_result);
$tpl->set('{conf_mess2}', $steam_attach_result);
$tpl->set('{conf_mess3}', $fb_attach_result);
$tpl->compile('content');
$tpl->clear();
