<?php

use GameCMS\Services\SteamApi\Authorization as SteamAuthorization;
use GameCMS\Services\VkApi\Authorization as VkAuthorization;

global $AA, $SC, $messages, $pdo, $auth_api, $full_site_host, $tpl, $PI;

if (!is_auth()) {
    $pages_urls = $AA->redirectPage();

    $U = new Users();

    $invited = getPageParam('ref');

    if ($invited) {
        $STH = pdo()->prepare('SELECT id FROM users WHERE id=:id LIMIT 1');
        $STH->execute([':id' => $invited]);
        $row = $STH->fetchObject();
        if (isset($row->id)) {
            $SC->set_cookie('invited', $row->id);
        }
    }

    $oauth_registration_result = '';
    if (isset($_GET['id']) and isset($_GET['key'])) {
        $id = getPageParam('id');
        $code = clean($_GET['key']);

        $user = Users::getUserData($id);
        if (!$user) {
            $oauth_registration_result = '<p class="text-danger">'.$messages['Account_does_not_exist'].'</p>';
        } else {
            if ($user->active == 1) {
                $oauth_registration_result = '<p class="text-success">'.$messages['Account_has_been_activated'].'</p>';
            } elseif ($code == Users::convert_password($user->login, configs()->salt)) {
                $STH = pdo()->prepare("UPDATE users SET active=:active WHERE id='{$id}' LIMIT 1");
                $STH->execute(['active' => '1']);

                $ES = new EventsRibbon($pdo);
                $ES->new_user($user->id, $user->login);

                if ($user->invited != 0) {
                    $noty = new_referal($user->id, $user->login);
                    send_noty($noty, $user->invited, 2);
                }

                $U->auth_user(
                    $SC,
                    $user->protect,
                    $user->password,
                    $user->login,
                    $user->id,
                    $user->rights,
                    $user->multi_account
                );
                header('Location: ../'.$pages_urls['main']);

                exit;
            } else {
                $oauth_registration_result = '<p class="text-danger">'.$messages['Invalid_key'].'</p>';
            }
        }
    }

    $reg = 0;
    $auth = 0;
    $user_info['vk_api'] = 0;
    $user_info['steam_api'] = 0;
    $user_info['fb_api'] = 0;

    $user_info['fb'] = 0;
    $user_info['steam_id'] = 0;
    $user_info['nick'] = null;

    if ($auth_api->steam_api == 1 && (isset($_GET['steam_reg']) || isset($_GET['steam_auth']))) {
        $steamAuthorization = new SteamAuthorization(
            $full_site_host,
            $auth_api->steam_key,
            getSteamApiTimeout()
        );

        [$steamUserInfo, $error] = $steamAuthorization->authorize($_GET['state']);
        if ($error) {
            log_error('steam-auth: '.$error);
            $oauth_registration_result = '<p class="text-danger">'.$messages['Error'].'</p>';
        } else {
            $user_info['steam_api'] = $steamUserInfo->steamId;

            if (isset($_GET['steam_auth']) && $steamUserInfo->data === 'login') {
                $auth = 1;
            } elseif (isset($_GET['steam_reg'])) {
                $reg = 1;

                $user_info['email'] = check($steamUserInfo->data);
                $user_info['steam_api'] = $steamUserInfo->steamId;
                $user_info['avatar'] = clean($steamUserInfo->avatar);
                $user_info['login'] = clean($steamUserInfo->login);
                $user_info['nick'] = clean($steamUserInfo->login);
                $user_info['password'] = 'none';

                if (configsSecondary()->auto_steam_id_fill) {
                    $user_info['steam_id'] = (new SteamIDOperations())->GetSteamID32($user_info['steam_api']);
                }
            }
        }
    }

    if ($auth_api->vk_api == 1 && isset($_GET['code'], $_GET['state']) && empty($_GET['fb_reg']) && empty($_GET['fb_auth'])) {
        $vkAuthorization = new VkAuthorization($auth_api->vk_id, configs()->vk_api_version, getVkApiTimeout());

        [$vkUserInfo, $error] = $vkAuthorization->authorize(
            $_GET['code'],
            $_GET['state'],
            $_GET['device_id'],
            $full_site_host.$pages_urls['main'],
        );
        if ($error) {
            log_error('vk-auth: '.$error);
            $oauth_registration_result = '<p class="text-danger">'.$messages['Error'].'</p>';
        } else {
            $user_info['vk_api'] = $vkUserInfo->user_id;

            if ($vkUserInfo->data === 'login') {
                $auth = 1;
            } else {
                $reg = 1;

                $user_info['email'] = check($vkUserInfo->data);
                $user_info['vk'] = 'id'.$vkUserInfo->user_id;
                $user_info['password'] = 'none';
                $user_info['login'] = clean($vkUserInfo->first_name.' '.$vkUserInfo->last_name);

                if ($vkUserInfo->has_photo) {
                    $user_info['avatar'] = $vkUserInfo->photo;
                }

                if (preg_match('/^[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{4}$/', $vkUserInfo->birth_day ?? '')) {
                    $birth = explode('.', $vkUserInfo->birth_day);

                    $birthDayDay = (int) $birth[0];
                    $birthDayMonth = (int) $birth[1];
                    $birthDayYear = (int) $birth[2];
                    if ($birthDayDay < 10) {
                        $birthDayDay = '0'.$birthDayDay;
                    }
                    if ($birthDayMonth < 10) {
                        $birthDayMonth = '0'.$birthDayMonth;
                    }
                    $user_info['birth'] = $birthDayYear.'-'.$birthDayMonth.'-'.$birthDayDay;
                }
            }
        }
    }

    if ($auth_api->fb_api == 1 && isset($_GET['code']) && (isset($_GET['fb_reg']) || isset($_GET['fb_auth']))) {
        if (isset($_GET['fb_reg'])) {
            $method = 'fb_reg';
        } else {
            $method = 'fb_auth';
        }

        $params = [
            'client_id' => $auth_api->fb_id,
            'redirect_uri' => $full_site_host.$pages_urls['main'].'?'.$method.'=1',
            'client_secret' => $auth_api->fb_key,
            'code' => $_GET['code'],
        ];

        $fb_token = json_decode(
            file_get_contents_curl('https://graph.facebook.com/oauth/access_token?'.http_build_query($params)),
            true
        );

        if (isset($fb_token['access_token'])) {
            $params = ['access_token' => $fb_token['access_token']];
            $userInfo = json_decode(
                file_get_contents_curl('https://graph.facebook.com/me?'.urldecode(http_build_query($params))),
                true
            );
        }

        if (!empty($userInfo) && !empty($userInfo['id'])) {
            $user_info['fb_api'] = $userInfo['id'];

            if (isset($_GET['fb_auth'])) {
                $auth = 1;
            } else {
                if (isset($_GET['state'])) {
                    $user_info['email'] = check($_GET['state']);
                }

                if (empty($user_info['email'])) {
                    $oauth_registration_result = '<p class="text-danger">'.$messages['Empty_email'].'</p>';
                } else {
                    $user_info['fb_api'] = $userInfo['id'];
                    $user_info['password'] = 'none';
                    $user_info['login'] = clean($userInfo['name']);
                    $user_info['avatar'] = 'https://graph.facebook.com/'.$userInfo['id'].'/picture?type=large';

                    $reg = 1;
                }
            }
        } else {
            $oauth_registration_result = '<p class="text-danger">'.$messages['Error'].'</p>';
        }
    }

    if ($reg === 1) {
        if ($user_info['vk_api'] != 0) {
            $user_info['fb_api'] = 0;
            $user_info['steam_api'] = 0;

            $STH = pdo()->prepare('SELECT id FROM users WHERE vk_api=:vk_api LIMIT 1');
            $STH->execute([':vk_api' => $user_info['vk_api']]);
            $row = $STH->fetchObject();
        } elseif ($user_info['steam_api'] != 0) {
            $user_info['fb_api'] = 0;
            $user_info['vk'] = '';
            $user_info['vk_api'] = 0;

            $STH = pdo()->prepare('SELECT id FROM users WHERE steam_api=:steam_api LIMIT 1');
            $STH->execute([':steam_api' => $user_info['steam_api']]);
            $row = $STH->fetchObject();
        } elseif ($user_info['fb_api'] != 0) {
            $user_info['vk'] = '';
            $user_info['vk_api'] = 0;
            $user_info['steam_api'] = 0;

            $STH = pdo()->prepare('SELECT id FROM users WHERE fb_api=:fb_api LIMIT 1');
            $STH->execute([':fb_api' => $user_info['fb_api']]);
            $row = $STH->fetchObject();
        }

        if (!empty($row) && !empty($row->id)) {
            $auth = 1;
        } else {
            $STH = pdo()->prepare('SELECT id FROM users WHERE login=:login LIMIT 1');
            $STH->execute([':login' => $user_info['login']]);
            $row = $STH->fetchObject();
            if (isset($row->id)) {
                $user_info['login'] = $AA->generateLogin($user_info['login']);
            }

            if (!$U->check_email($user_info['email'])) {
                $oauth_registration_result = '<p class="text-danger">'.$messages['Invalid_email'].'</p>';
            } elseif (!$U->check_email_busyness($user_info['email'])) {
                $oauth_registration_result = '<p class="text-danger">'.$messages['Email_already_registed'].'</p>';
            } else {
                $user_info['regdate'] = date('Y-m-d H:i:s');

                if (empty($user_info['birth'])) {
                    $user_info['birth'] = '1960-01-01';
                }

                if (empty($user_info['avatar'])) {
                    $user_info['avatar'] = 'files/avatars/no_avatar.jpg';
                } else {
                    $user_info['avatar'] = downloadUserAvatar($user_info['avatar']);
                }

                $user = $U->entry_user(
                    $user_info['login'],
                    $user_info['password'],
                    $user_info['email'],
                    configs()->conf_us,
                    $user_info['vk'],
                    $user_info['vk_api'],
                    $user_info['fb'],
                    $user_info['fb_api'],
                    $user_info['steam_id'],
                    $user_info['steam_api'],
                    $user_info['avatar'],
                    $user_info['birth'],
                    $user_info['nick']
                );

                if (!empty($user->id)) {
                    $answer = $U->after_registration_actions(
                        $SC,
                        configs()->salt,
                        configs()->name,
                        $user->id,
                        $full_site_host.$pages_urls['main']
                    );

                    if ($answer['message'] != 'error') {
                        $oauth_registration_result = '<p class="text-success">'.$answer['message'].'</p>';
                        sendmail($user_info['email'], $answer['letter']['subject'], $answer['letter']['message'], $pdo);
                    } else {
                        $oauth_registration_result = '<p class="text-danger">'.$messages['Error'].'</p>';
                    }

                    if (is_auth()) {
                        header('Location: ../'.$pages_urls['main']);

                        exit;
                    }
                } else {
                    $oauth_registration_result = '<p class="text-danger">'.$messages['Error_You_are_not_logged_in'].'</p>';
                }
            }
        }
    }

    if ($auth == 1) {
        if ($user_info['vk_api'] != 0) {
            $STH = pdo()->prepare(
                'SELECT id,password,login,rights,active,protect,multi_account FROM users WHERE vk_api=:vk_api LIMIT 1'
            );
            $STH->execute([':vk_api' => $user_info['vk_api']]);
            $row = $STH->fetchObject();
            $modal = $messages['Reg_modal_vk'];
        } elseif ($user_info['steam_api'] != 0) {
            $STH = pdo()->prepare(
                'SELECT id,password,login,rights,active,protect,multi_account FROM users WHERE steam_api=:steam_api LIMIT 1'
            );
            $STH->execute([':steam_api' => $user_info['steam_api']]);
            $row = $STH->fetchObject();
            $modal = $messages['Reg_modal_steam'];
        } elseif ($user_info['fb_api'] != 0) {
            $STH = pdo()->prepare(
                'SELECT id,password,login,rights,active,protect,multi_account FROM users WHERE fb_api=:fb_api LIMIT 1'
            );
            $STH->execute([':fb_api' => $user_info['fb_api']]);
            $row = $STH->fetchObject();
            $modal = $messages['Reg_modal_fb'];
        }

        if (isset($row->id)) {
            if ($row->active != 1) {
                $oauth_registration_result = '<p class="text-danger">'.$messages['please_act_account'].'</p>';
            } else {
                $result = $U->auth_user(
                    $SC,
                    $row->protect,
                    $row->password,
                    $row->login,
                    $row->id,
                    $row->rights,
                    $row->multi_account
                );

                if ($result['status']) {
                    header('Location: ../'.$pages_urls['main']);

                    exit;
                }

                $oauth_registration_result = '<p class="text-danger">'.$result['response'].'</p>';
            }
        } else {
            $oauth_registration_result = $modal.'<p class="text-danger">'.$messages['Account_does_not_exist'].'</p>';
        }
    }

    $tpl->load_template('elements/title.tpl');
    $tpl->set('{title}', page()->title);
    $tpl->set('{name}', configs()->name);
    $tpl->compile('title');
    $tpl->clear();

    $tpl->load_template('head.tpl');
    $tpl->set('{title}', $tpl->result['title'], false);
    $tpl->set('{site_name}', configs()->name);
    $tpl->set('{image}', page()->image);
    $tpl->set('{robots}', page()->robots);
    $tpl->set('{type}', page()->kind);
    $tpl->set('{description}', page()->description);
    $tpl->set('{keywords}', page()->keywords);
    $tpl->set('{url}', page()->full_url);
    $tpl->set('{other}', '');
    $tpl->set('{token}', token());
    $tpl->set('{cache}', configs()->cache);
    $tpl->set('{template}', get_template());
    $tpl->compile('content');
    $tpl->clear();

    $menu = $tpl->get_menu();

    $nav = [$PI->to_nav('main', 1, 0)];
    $nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

    include_once __DIR__.'/../../inc/not_authorized.php';

    $tpl->load_template('/index/body.tpl');
    $tpl->set('{conf_mess}', $oauth_registration_result);
    $tpl->set('{template}', get_template());
    $tpl->compile('content');
    $tpl->clear();
} else {
    $tpl->load_template('elements/title.tpl');
    $tpl->set('{title}', page()->title);
    $tpl->set('{name}', configs()->name);
    $tpl->compile('title');
    $tpl->clear();

    $tpl->load_template('head.tpl');
    $tpl->set('{title}', $tpl->result['title'], false);
    $tpl->set('{site_name}', configs()->name);
    $tpl->set('{image}', page()->image);
    $tpl->set('{robots}', page()->robots);
    $tpl->set('{type}', page()->kind);
    $tpl->set('{description}', page()->description);
    $tpl->set('{keywords}', page()->keywords);
    $tpl->set('{url}', page()->full_url);
    $tpl->set('{other}', '');
    $tpl->set('{token}', token());
    $tpl->set('{cache}', configs()->cache);
    $tpl->set('{template}', get_template());
    $tpl->compile('content');
    $tpl->clear();

    $menu = $tpl->get_menu();

    $nav = [$PI->to_nav('main', 1, 0)];
    $nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

    include_once __DIR__.'/../../inc/authorized.php';

    $tpl->load_template('/home/index.tpl');
    $tpl->set('{template}', get_template());
    $tpl->compile('content');
    $tpl->clear();

    $tpl->load_template('/home/right.tpl');
    $tpl->set('{login}', $_SESSION['login']);
    $tpl->set('{avatar}', user()->avatar);
    $tpl->set('{id}', user()->id);
    $tpl->set('{template}', get_template());
    $tpl->compile('content');
    $tpl->clear();
}
