<?php
if(!isDevMode()){
	show_error_page('not_allowed');
}

global $PI;

$logs = (new Logs())->getLogs();

(new Page())
	->setBreadCrumbs(
		[
			$PI->to_nav('admin'),
			$PI->to_nav('admin_diagnostics', 1)
		]
	)
	->collectPage('diagnostics.tpl', [
		'phpversion'    => phpversion(),
		'paymentsDebug' => configsSecondary()->payments_debug,
		'version'       => getCurrentVersion(),
		'displayErrors' => configs()->display_errors,
		'customStores'  => implode(
			',',
			array_map(
				function($store) {
					return $store->name;
				},
				json_decode(configsSecondary()->custom_stores)
			)
		)
	]);
