<?php

namespace GameCMS\Statistics;

use GameCMS\Common\Error;
use GameCMS\Models\Server;

interface StatisticIntegration
{
    public function isBlank(): bool;

    /**
     * @return array{?\PDO, ?Error}
     */
    public function getStorageConnection(Server $server): array;

    public function renderCommonStatistics(
        Server $server,
        \PDO $connection,
        \Template $tpl,
        string $name,
        int $start,
        int $limit
    ): string;

    public function renderWeaponsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string;

    public function renderMapsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string;

    public function removeStats(Server $server, \PDO $connection, string $playerId): bool;

    public function getStatsCount(Server $server, \PDO $connection): int;

    public function isHasRank(Server $server, \PDO $connection): bool;

    public function isValidStatisticsSortType(int $type): bool;

    public function isValidDataBase(\PDO $connection, string $table = ''): bool;
}
