<?php

namespace GameCMS\Services\SteamApi;

use GameCMS\Clients\Curl;
use GameCMS\Common\Error;
use GameCMS\Services\SteamApi\DTO\UsersGetInfoDTO;

class Users
{
    private Curl $client;
    private string $secret;

    public function __construct(
        string $secret,
        int $timeout = 10
    ) {
        $this->client = new Curl();
        $this->client->setUrl('https://api.steampowered.com');
        $this->client->setTimeout($timeout);

        $this->secret = $secret;
    }

    /**
     * @return array{?UsersGetInfoDTO[], ?Error}
     */
    public function getInfo(array $steamIds): array
    {
        $response = $this->client->get('/ISteamUser/GetPlayerSummaries/v0002/', [
            'key' => $this->secret,
            'steamids' => implode(',', $steamIds),
        ]);

        $responseData = json_decode($response, true);
        if (!$responseData || !$responseData['response']) {
            return [null, error('invalid response data')];
        }

        $items = [];

        foreach ($responseData['response']['players'] as $player) {
            $item = new UsersGetInfoDTO();
            $item->avatar = $player['avatarfull'];
            $item->login = $player['personaname'];

            $items[] = $item;
        }

        return [$items, null];
    }
}
