<?php

namespace GameCMS\Integrations\Mutes;

use GameCMS\Models\Server;

abstract class DatabasedIntegration
{
    public function getStorageConnection(Server $server): array
    {
        $connection = db_connect($server->db_host, $server->db_db, $server->db_user, $server->db_pass);

        if (!$connection) {
            return [null, error('Не удалось подключиться к базе данных сервера')];
        }

        set_names($connection, $server->db_code);

        return [$connection, null];
    }
}
