<?php

use GameCMS\Integrations\Integrations;
use GameCMS\Repositories\ServerRepository;
use GameCMS\Services\BansService;
use GameCMS\Services\MutesService;
use GameCMS\Services\StatisticsService;

include_once __DIR__.'/../inc/start.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken() || !is_auth()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

if (isset($_POST['dell_new']) and (is_worthy('q') or is_admin())) {
    $id = check($_POST['id'], 'int');
    $pdo->exec("DELETE FROM `news` WHERE id='{$id}' LIMIT 1");

    $STH = $pdo->prepare('SELECT `id` FROM `news__comments` WHERE `new_id`=:new_id');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':new_id' => $id]);
    while ($row = $STH->fetch()) {
        $STH2 = $pdo->prepare("DELETE FROM `events` WHERE `data_id`=:data_id AND `type` = '2' LIMIT 1");
        $STH2->execute([':data_id' => $row->id]);
    }

    $pdo->exec("DELETE FROM `news__comments` WHERE `new_id`='{$id}'");

    $STH = $pdo->prepare("DELETE FROM `events` WHERE `data_id`=:data_id AND `type` = '1' LIMIT 1");
    $STH->execute([':data_id' => $id]);

    write_log('Удалена новость ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['load_sections']) and is_worthy('t')) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $Forum = new Forum($pdo, $tpl);
    echo $Forum->get_sections_admin(get_template(), $users_groups);

    exit;
}
if (isset($_POST['load_forums']) and is_worthy('t')) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $Forum = new Forum($pdo, $tpl);
    echo $Forum->get_forums_admin($id, get_template());

    exit;
}
if (isset($_POST['load_sections_list']) and is_worthy('t')) {
    $Forum = new Forum($pdo);
    $Forum->get_sections_list_admin();

    exit;
}
if (isset($_POST['load_forum_img']) and is_worthy('t')) {
    if (isset($_POST['id'])) {
        $id = check($_POST['id'], 'int');
    }

    if (empty($_FILES['img']['name'])) {
        exit('<p class="text-danger">Выберите изображение!</p>');
    }
    $path = 'files/forums_imgs/';
    $date = time();

    if (if_jpg($_FILES['img']['name'])) {
        $filename = $_FILES['img']['name'];
        $source = $_FILES['img']['tmp_name'];
        $target = '../'.$path.$filename;
        if (!move_uploaded_file($source, $target)) {
            exit('<p class="text-danger">Ошибка загрузки файла!</p>');
        }

        $im = imagecreatefromjpeg('../'.$path.$filename);
        clip_image($im, 300, $path.$date);

        $img = $path.$date.'.jpg';
        unlink($target);
    } elseif (if_gif($_FILES['img']['name']) || if_png($_FILES['img']['name'])) {
        $file_type = substr($_FILES['img']['name'], strrpos($_FILES['img']['name'], '.') + 1);
        $source = $_FILES['img']['tmp_name'];
        $img = $path.$date.'.'.$file_type;
        $target = '../'.$img;
        if (!move_uploaded_file($source, $target)) {
            exit('<p class="text-danger">Ошибка загрузки файла!</p>');
        }
    } else {
        exit('<p class="text-danger">Изображение должно быть в формате JPG,GIF или PNG</p>');
    }

    if (!empty($id)) {
        $STH = $pdo->query("SELECT `img` FROM `forums` WHERE id='{$id}'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $tmp = $STH->fetch();
        if ('files/forums_imgs/none.jpg' != $tmp->img) {
            unlink('../'.$tmp->img);
        }
        $STH = $pdo->prepare("UPDATE `forums` SET `img`=:img WHERE `id`='{$id}' LIMIT 1");
        $STH->execute([':img' => $img]);

        exit('<script>document.getElementById("image'.$id.'").src = "../'.$img.'" </script>');
    }

    exit('<script>document.getElementById("image").src = "../'.$img.'" </script><input type="hidden" id="forum_img" value="'.$img.'">');
}
if (isset($_POST['add_forum']) and is_worthy('t')) {
    $section = check($_POST['section'], 'int');
    $img = check($_POST['img'], null);
    $name = check($_POST['name'], null);
    $description = check($_POST['description'], null);

    if (empty($img)) {
        $img = 'files/forums_imgs/none.jpg';
    }
    if (empty($section)) {
        exit(json_encode(['status' => '2', 'input' => 'sections_list', 'reply' => '']));
    }
    if (empty($name)) {
        exit(json_encode(['status' => '2', 'input' => 'forum_name', 'reply' => 'Заполните!']));
    }
    if (empty($description)) {
        $description = '';
    }
    if (mb_strlen($name, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'forum_name', 'reply' => 'Не более 255 символов!']));
    }
    if (mb_strlen($description, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'forum_description', 'reply' => 'Не более 255 символов!']));
    }

    $Forum = new Forum($pdo);
    $Forum->add_forum($section, $name, $description, $img);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['edit_forum']) and is_worthy('t')) {
    $name = check($_POST['name'], null);
    $description = check($_POST['description'], null);
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit;
    }
    if (empty($name)) {
        exit(json_encode(['status' => '2', 'input' => 'forum_name', 'reply' => 'Заполните!']));
    }
    if (empty($description)) {
        $description = '';
    }

    if (mb_strlen($name, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'forum_name', 'reply' => 'Не более 255 символов!']));
    }
    if (mb_strlen($description, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'forum_description', 'reply' => 'Не более 255 символов!']));
    }

    $Forum = new Forum($pdo);
    $Forum->edit_forum($id, $name, $description);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['dell_forum']) and is_worthy('t')) {
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    $Forum->dell_forum($id, 2);

    write_log('Удален форум ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['dell_topic']) and is_worthy('e')) {
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    $Forum->dell_topic($id, 2);

    write_log('Удалена тема форума ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['up_forum']) and is_worthy('t')) {
    $id = check($_POST['id'], 'int');
    $section_id = check($_POST['id2'], 'int');

    if (empty($id) or empty($section_id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    $Forum->up_forum($id, $section_id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['down_forum']) and is_worthy('t')) {
    $id = check($_POST['id'], 'int');
    $section_id = check($_POST['id2'], 'int');

    if (empty($id) or empty($section_id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    $Forum->down_forum($id, $section_id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['load_open_tickets']) and is_worthy('p')) {
    $i = 0;
    $STH = $pdo->query("SELECT tickets.id,tickets.have_answer,tickets.name,tickets.date,tickets.last_answer,tickets.author,users.login FROM tickets LEFT JOIN users ON tickets.author = users.id WHERE tickets.status='1' ORDER BY tickets.last_answer DESC");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        ++$i;
        ?>
			<tr>
				<td><a href="ticket?id=<?php echo $row->id; ?>"><?php echo $row->name; ?></a></td>
				<td><a href="../profile?id=<?php echo $row->author; ?>"><?php echo $row->login; ?></a></td>
				<td>
					<?php
                        echo expand_date($row->last_answer, 7);
        if (1 == $row->have_answer) {
            echo '<span class="text-info"> от администрации</span>';
        } else {
            echo '<span class="text-warning"> от пользователя</span>';
        }
        ?>		
				</td>
				<td><?php echo expand_date($row->date, 7); ?></td>
			</tr>
		<?php
    }

    if (0 == $i) {
        exit(tableRowError('Открытых тикетов нет'));
    }

    exit;
}
if (isset($_POST['load_close_tickets']) and is_worthy('p')) {
    $load_val = check($_POST['load_val'], 'int');
    if (empty($load_val)) {
        $load_val = 1;
    }

    $start = ($load_val - 1) * 20;
    $end = 20;
    $i = $start;
    $i2 = 0;
    $STH = $pdo->query("SELECT tickets.id,tickets.name,tickets.date,tickets.last_answer,tickets.closed,users.login FROM tickets LEFT JOIN users ON tickets.closed = users.id WHERE tickets.status='2' ORDER BY tickets.last_answer DESC LIMIT ".$start.', '.$end);
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        ++$i;
        ++$i2;
        ?>
			<tr>
				<td><a href="ticket?id=<?php echo $row->id; ?>"><?php echo $row->name; ?></a></td>
				<td><a href="../profile?id=<?php echo $row->closed; ?>"><?php echo $row->login; ?></a></td>
				<td><?php echo expand_date($row->last_answer, 7); ?></td>
				<td><?php echo expand_date($row->date, 7); ?></td>
			</tr>
		<?php
    }

    if (($load_val > 0) and ($i2 > 19)) {
        ++$load_val;

        exit('<tr id="loader_'.$load_val.'"><td colspan="10"><span class="empty-element" onclick="load_close_tickets(\''.$load_val.'\');">Подгрузить тикеты</span></td></tr>');
    }
    if (($load_val > 0) and ($i2 < 20)) {
        exit(tableRowError('Все тикеты выгружены'));
    }
    if (0 == $i) {
        exit(tableRowError('Закрытых тикетов нет'));
    }

    exit;
}
if (isset($_POST['dell_ticket']) and is_worthy('l')) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        $result = ['status' => '2'];

        exit(json_encode($result));
    }
    $STH = $pdo->query("SELECT files FROM tickets WHERE id='{$id} '");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (isset($row->files) and 'none' != $row->files) {
        unlink('../'.$row->files);
    }

    $pdo->exec("DELETE FROM tickets WHERE id='{$id}' LIMIT 1");
    $pdo->exec("DELETE FROM tickets__answers WHERE ticket='{$id}'");

    write_log('Удален тикет ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['dell_ban']) and is_worthy('o')) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = $pdo->query("SELECT `id`, `server`, `img` FROM `bans` WHERE id='{$id}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '2']));
    }
    if (!is_worthy_specifically('o', $row->server)) {
        exit(json_encode(['status' => '2']));
    }

    $data = explode(';', $row->img);
    for ($i = 0; $i < count($data); ++$i) {
        if (!empty($data[$i])) {
            unlink('../'.$data[$i]);
        }
    }
    $pdo->exec("DELETE FROM bans WHERE id='{$id}' LIMIT 1");
    $pdo->exec("DELETE FROM bans__comments WHERE ban_id='{$id}'");

    write_log('Удалена заявка на разбан ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['close_ban_from_apps']) and is_worthy('i')) {
    $id = check($_POST['id'], 'int');
    $action_type = check($_POST['type'], 'int');
    $bid = check($_POST['bid'], 'int');

    if (empty($id) || ('1' != $action_type and '2' != $action_type)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = $pdo->query("SELECT server, closed FROM bans WHERE id='{$id}' LIMIT 1");
    $row = $STH->fetchObject();
    if (empty($row->server)) {
        exit(json_encode(['status' => '2']));
    }

    if (false === getConfigAdditional('isAllowChangeBanAppSolution', true) && 0 != $row->closed) {
        exit(json_encode(['status' => '2']));
    }

    if (!is_worthy_specifically('i', $row->server)) {
        exit(json_encode(['status' => '2']));
    }

    if (!empty($bid)) {
        $server = ServerRepository::getById($row->server);
        if (empty($server)) {
            exit(json_encode(['status' => '2']));
        }

        $bansService = new BansService();
        $integrator = $bansService->getIntegrator($server->type);
        if ($integrator->isBlank()) {
            exit(json_encode(['status' => '2']));
        }

        [$connection, $error] = $integrator->getStorageConnection($server);
        if ($error) {
            exit(json_encode(['status' => '2']));
        }

        $table = set_prefix($server->db_prefix, 'bans');

        if (
            Integrations::AMXBANS == $server->type
            || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
            || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
        ) {
            if ('1' == $action_type) {
                $data = [':expired' => '1', ':unban_type' => '-1', ':ban_closed' => $_SESSION['id'], ':id' => $bid];
            } else {
                $data = [':expired' => '0', ':unban_type' => null, ':ban_closed' => null, ':id' => $bid];
            }

            $STH = $connection->prepare(
                "UPDATE `{$table}` SET `expired`=:expired, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1"
            );
            $STH->execute($data);
        }

        if (Integrations::SOURCEBANS == $server->type) {
            if ('1' == $action_type) {
                $data = [
                    ':RemovedBy' => '0',
                    ':RemoveType' => 'U',
                    ':unban_type' => '-1',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $bid,
                ];
            } else {
                $data = [
                    ':RemovedBy' => null,
                    ':RemoveType' => null,
                    ':unban_type' => null,
                    ':ban_closed' => null,
                    ':id' => $bid,
                ];
            }

            $STH = $connection->prepare(
                "UPDATE `{$table}` SET `RemovedBy`=:RemovedBy,`RemoveType`=:RemoveType, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1"
            );
            $STH->execute($data);
        }

        if (Integrations::IKS == $server->type) {
            if ('1' == $action_type) {
                $data = [
                    ':Unbanned' => '1',
                    ':unban_type' => '-1',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $bid,
                ];
            } else {
                $data = [
                    ':Unbanned' => '0',
                    ':unban_type' => null,
                    ':ban_closed' => null,
                    ':id' => $bid,
                ];
            }

            $STH = $connection->prepare(
                "UPDATE `{$table}` SET `Unbanned`=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1"
            );
            $STH->execute(
                $data
            );
        }
    }

    $STH = $pdo->prepare(
        "UPDATE `bans` SET `status`=:status, `closed`=:closed, `have_answer`=:have_answer WHERE `id`='{$id}' LIMIT 1"
    );
    $STH->execute(['status' => $action_type, 'closed' => $_SESSION['id'], 'have_answer' => '1']);

    ++$action_type;
    $STH = $pdo->query(
        "SELECT `bans`.`author`, `users`.`email`, `users`.`email_notice` FROM `bans` LEFT JOIN `users` ON `users`.`id`=`bans`.`author` WHERE `bans`.`id`='{$id}' LIMIT 1"
    );
    $row = $STH->fetchObject();

    incNotifications();
    $noty = close_ban_from_apps_noty($id);
    send_noty($noty, $row->author, $action_type);

    if (1 == $row->email_notice) {
        $letter = close_ban_from_apps_letter($id, $full_site_host);
        sendmail($row->email, $letter['subject'], $letter['message'], $pdo);
    }

    exit(json_encode(['status' => '1', 'closed' => $_SESSION['id'], 'closed_a' => $_SESSION['login']]));
}
if (isset($_POST['close_ban']) and is_worthy('s')) {
    $serverId = check($_POST['server'], 'int');
    $bid = check($_POST['bid'], 'int');

    if (empty($bid) or empty($serverId)) {
        exit(json_encode(['status' => '2']));
    }

    if (!is_worthy_specifically('s', $serverId)) {
        exit(json_encode(['status' => '2']));
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $bansService = new BansService();
    $integrator = $bansService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    $table = set_prefix($server->db_prefix, 'bans');

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $STH = $connection->prepare(
            "UPDATE `{$table}` SET `expired`=:expired, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1"
        );
        $STH->execute([':expired' => '1', ':unban_type' => '-1', ':ban_closed' => $_SESSION['id'], ':id' => $bid]);
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $STH = $connection->prepare(
            "UPDATE `{$table}` SET `RemovedBy`=:RemovedBy,`RemoveType`=:RemoveType, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1"
        );
        $STH->execute(
            [
                ':RemovedBy' => '0',
                ':RemoveType' => 'U',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':id' => $bid,
            ]
        );
    }

    if (Integrations::IKS == $server->type) {
        $STH = $connection->prepare(
            "UPDATE `{$table}` SET `Unbanned`=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1"
        );
        $STH->execute(
            [
                ':Unbanned' => '1',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':id' => $bid,
            ]
        );
    }

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['close_mute']) and is_worthy('s')) {
    $serverId = check($_POST['server'], 'int');
    $bid = check($_POST['bid'], 'int');

    if (empty($bid) or empty($serverId)) {
        exit(json_encode(['status' => '2']));
    }

    if (!is_worthy_specifically('s', $serverId)) {
        exit(json_encode(['status' => '2']));
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $mutesService = new MutesService();
    $integrator = $mutesService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    if (
        Integrations::USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $table = 'comms';

        if (!check_table($table, $pdo)) {
            exit(json_encode(['status' => '2']));
        }

        $STH = $connection->prepare(
            "UPDATE {$table} SET expired=:expired, modified_by=:modified_by WHERE `bid`=:id LIMIT 1"
        );
        $STH->execute([':expired' => '-1', ':modified_by' => $_SESSION['id'], ':id' => $bid]);
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'comms');

        $STH = $connection->prepare(
            "UPDATE {$table} SET RemovedBy=:RemovedBy, RemoveType=:RemoveType, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1"
        );
        $STH->execute(
            [
                ':RemovedBy' => '0',
                ':RemoveType' => 'U',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':id' => $bid,
            ]
        );
    }

    if (Integrations::IKS == $server->type) {
        $table = set_prefix($server->db_prefix, 'mutes');

        $STH = $connection->prepare(
            "UPDATE {$table} SET Unbanned=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1"
        );
        $STH->execute(
            [
                ':Unbanned' => '1',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':id' => $bid,
            ]
        );
    }

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['change_ban_end']) and is_worthy('s')) {
    $serverId = check($_POST['server'], 'int');
    $bid = check($_POST['bid'], 'int');
    $date = check($_POST['date'], null);

    if (empty($bid) or empty($serverId) or empty($date)) {
        exit(json_encode(['status' => '2']));
    }

    if ('00.00.0000 00:00' == $_POST['date']) {
        $date = 0;
    } else {
        $date = strtotime($date);
    }

    if (!is_worthy_specifically('s', $serverId)) {
        exit(json_encode(['status' => '2']));
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $bansService = new BansService();
    $integrator = $bansService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    $ban_end_title = '';
    $class = '';
    $ban_length = 0;

    $table = set_prefix($server->db_prefix, 'bans');

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $STH = $connection->prepare("SELECT `ban_created` FROM `{$table}` WHERE `bid`=:bid LIMIT 1");
        $STH->execute([':bid' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->ban_created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = $row->ban_created;
        } else {
            $ban_length = round(($date - $row->ban_created) / 60);
            $ban_ends = $ban_length * 60 + $row->ban_created;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [
                ':expired' => '0',
                ':ban_length' => $ban_length,
                ':unban_type' => null,
                ':ban_closed' => null,
                ':bid' => $bid,
            ];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [
                ':expired' => '1',
                ':ban_length' => $ban_length,
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':bid' => $bid,
            ];
        }

        $STH = $connection->prepare("UPDATE `{$table}` SET `expired`=:expired, `ban_length`=:ban_length, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:bid LIMIT 1");
        $STH->execute($data);

        $ban_length = $ban_length * 60;
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $STH = $connection->prepare("SELECT `created` FROM `{$table}` WHERE `bid`=:bid LIMIT 1");
        $STH->execute([':bid' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = $row->created;
        } else {
            $ban_length = round($date - $row->created);
            $ban_ends = $row->created + $ban_length;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [':ends' => $ban_ends, ':length' => $ban_length, ':RemovedBy' => null, ':RemoveType' => null, ':unban_type' => null, ':ban_closed' => null, ':bid' => $bid];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [':ends' => $ban_ends, ':length' => $ban_length, ':RemovedBy' => '0', ':RemoveType' => 'U', ':unban_type' => '-1', ':ban_closed' => $_SESSION['id'], ':bid' => $bid];
        }

        $STH = $connection->prepare("UPDATE `{$table}` SET `ends`=:ends,`length`=:length,`RemovedBy`=:RemovedBy,`RemoveType`=:RemoveType, `unban_type`=:unban_type,`ban_closed`=:ban_closed WHERE `bid`=:bid LIMIT 1");
        $STH->execute($data);
    }

    if (Integrations::IKS == $server->type) {
        $STH = $connection->prepare("SELECT `created` FROM `{$table}` WHERE `id`=:id LIMIT 1");
        $STH->execute([':id' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = 0;
        } else {
            $ban_length = round($date - $row->created);
            $ban_ends = $row->created + $ban_length;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [':end' => $ban_ends, ':time' => $ban_length, ':Unbanned' => '0', ':unban_type' => null, ':ban_closed' => null, ':id' => $bid];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [':end' => $ban_ends, ':time' => $ban_length, ':Unbanned' => '1', ':unban_type' => '-1', ':ban_closed' => $_SESSION['id'], ':id' => $bid];
        }

        $STH = $connection->prepare("UPDATE `{$table}` SET `end`=:end, `time`=:time, `Unbanned`=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1");
        $STH->execute($data);
    }

    exit(
        json_encode(
            [
                'status' => '1',
                'length' => expand_seconds2($ban_length),
                'ends' => $ban_end_title,
                'class' => $class,
            ]
        )
    );
}
if (isset($_POST['change_mute_end']) and is_worthy('s')) {
    $serverId = check($_POST['server'], 'int');
    $bid = check($_POST['bid'], 'int');
    $date = check($_POST['date'], null);

    if (empty($bid) or empty($serverId) or empty($date)) {
        exit(json_encode(['status' => '2']));
    }

    if ('00.00.0000 00:00' == $_POST['date']) {
        $date = 0;
    } else {
        $date = strtotime($date);
    }

    if (!is_worthy_specifically('s', $serverId)) {
        exit(json_encode(['status' => '2']));
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $mutesService = new MutesService();
    $integrator = $mutesService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    $ban_end_title = '';
    $class = '';
    $ban_length = 0;

    if (
        Integrations::USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $table = 'comms';

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => '2']));
        }

        $STH = $pdo->prepare("SELECT `created` FROM `{$table}` WHERE `bid`=:bid LIMIT 1");
        $STH->execute([':bid' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = $row->created;
        } else {
            $ban_length = ceil(($date - $row->created) / 60);
            $ban_ends = $date;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [
                ':expired' => $ban_ends,
                ':length' => $ban_length,
                ':type' => 0,
                ':modified_by' => '',
                ':bid' => $bid,
            ];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [
                ':expired' => '-1',
                ':length' => $ban_length,
                ':type' => '-1',
                ':modified_by' => $_SESSION['id'],
                ':bid' => $bid,
            ];
        }

        $STH = $pdo->prepare(
            "UPDATE `{$table}` SET `expired`=:expired, `length`=:length, `type`=:type, `modified_by`=:modified_by WHERE `bid`=:bid LIMIT 1"
        );
        $STH->execute($data);

        $ban_length = $ban_length * 60;
        $ban_ends = ($ban_length + $row->created) * 60;
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'comms');

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => '2']));
        }

        $STH = $connection->prepare("SELECT `created` FROM `{$table}` WHERE `bid`=:bid LIMIT 1");
        $STH->execute([':bid' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = $row->created;
        } else {
            $ban_length = round($date - $row->created);
            $ban_ends = $row->created + $ban_length;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [
                ':ends' => $ban_ends,
                ':length' => $ban_length,
                ':RemovedBy' => null,
                ':RemoveType' => null,
                ':unban_type' => null,
                ':ban_closed' => null,
                ':bid' => $bid,
            ];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [
                ':ends' => $ban_ends,
                ':length' => $ban_length,
                ':RemovedBy' => '0',
                ':RemoveType' => 'U',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':bid' => $bid,
            ];
        }

        $STH = $connection->prepare(
            "UPDATE `{$table}` SET `ends`=:ends,`length`=:length,`RemovedBy`=:RemovedBy,`RemoveType`=:RemoveType, `unban_type`=:unban_type,`ban_closed`=:ban_closed WHERE `bid`=:bid LIMIT 1"
        );
        $STH->execute($data);
    }

    if (Integrations::IKS == $server->type) {
        $table = set_prefix($server->db_prefix, 'mutes');

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => 2]));
        }

        $STH = $connection->prepare("SELECT `created` FROM `{$table}` WHERE `id`=:id LIMIT 1");
        $STH->execute([':id' => $bid]);
        $row = $STH->fetchObject();

        if (empty($row->created)) {
            exit(json_encode(['status' => '2']));
        }

        if (0 == $date) {
            $ban_length = 0;
            $ban_ends = 0;
        } else {
            $ban_length = round($date - $row->created);
            $ban_ends = $row->created + $ban_length;
        }

        if ($date > time() || 0 == $ban_length) {
            if (0 == $ban_length) {
                $ban_end_title = 'Никогда';
                $class = 'danger';
            } else {
                $ban_end_title = expand_date($ban_ends, 1);
                $class = '';
            }
            $data = [
                ':end' => $ban_ends,
                ':time' => $ban_length,
                ':Unbanned' => '0',
                ':unban_type' => null,
                ':ban_closed' => null,
                ':id' => $bid,
            ];
        } else {
            $ban_end_title = expand_date($ban_ends, 1);
            $class = 'success';
            $data = [
                ':end' => $ban_ends,
                ':time' => $ban_length,
                ':Unbanned' => '1',
                ':unban_type' => '-1',
                ':ban_closed' => $_SESSION['id'],
                ':id' => $bid,
            ];
        }

        $STH = $connection->prepare(
            "UPDATE `{$table}` SET `end`=:end, `time`=:time, `Unbanned`=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1"
        );
        $STH->execute($data);
    }

    exit(
        json_encode(
            [
                'status' => '1',
                'length' => expand_seconds2($ban_length),
                'ends' => $ban_end_title,
                'class' => $class,
            ]
        )
    );
}
if (isset($_POST['dell_user_stats']) and is_worthy('h')) {
    $serverId = check($_POST['server'], 'int');
    $id = check($_POST['id'], 'int');

    if (empty($id) or empty($serverId)) {
        exit(json_encode(['status' => '2']));
    }

    if (!is_worthy_specifically('h', $serverId)) {
        exit(json_encode(['status' => '2']));
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $statisticsService = new StatisticsService();
    $integrator = $statisticsService->getIntegrator($server->st_type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    $integrator->removeStats($server, $connection, $id);

    write_log('Удалена статистика пользователя ID:'.$id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['ban_player']) and is_worthy('s')) {
    $nick = check($_POST['nick'], null);
    $ip = check($_POST['ip'], null);
    $steam_id = check($_POST['steam_id'], null);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['removeComplaint']) && is_worthy('u')) {
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit(json_encode(['status' => 2]));
    }

    $STH = $pdo->prepare(
        'SELECT id, accused_admin_server_id, screens FROM complaints WHERE id = :id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);
    $row = $STH->fetch();

    if (empty($row->id)) {
        exit(json_encode(['status' => 2]));
    }

    if (!is_worthy_specifically('o', $row->accused_admin_server_id)) {
        exit(json_encode(['status' => 2]));
    }

    $screens = explode(';', $row->screens);
    foreach ($screens as $screen) {
        if (!empty($screen)) {
            unlink('../'.$screen);
        }
    }

    $STH = $pdo->prepare('DELETE FROM complaints WHERE id=:id LIMIT 1');
    $STH->execute([':id' => $id]);

    $STH = $pdo->prepare('DELETE FROM complaints__comments WHERE complaint_id=:id LIMIT 1');
    $STH->execute([':id' => $id]);

    write_log('Удалена жалоба ID:'.$id);

    exit(json_encode(['status' => 1]));
}
if (isset($_POST['closeComplaint']) && is_worthy('k')) {
    $id = check($_POST['id'], 'int');
    $sentence = check($_POST['sentence'], 'int');

    if (!in_array($sentence, [1, 2, 3, 4])) {
        exit(json_encode(['status' => 2]));
    }

    if (empty($id)) {
        exit(json_encode(['status' => 2]));
    }

    $STH = $pdo->prepare(
        'SELECT 
    				complaints.sentence, 
    				complaints.accused_admin_server_id, 
    				author.id as author_id, 
				    author.email as author_email, 
				    author.email_notice as author_email_notice,
   					accused.id as accused_id, 
      				accused.email as accused_email, 
				    accused.email_notice as accused_email_notice
				FROM 
				    complaints 
				        LEFT JOIN users author ON author.id=complaints.author_id
						LEFT JOIN users accused ON accused.id=complaints.accused_profile_id
				WHERE complaints.id = :id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);
    $row = $STH->fetch();

    if (0 != $row->sentence) {
        exit(json_encode(['status' => 2]));
    }

    if (empty($row->accused_admin_server_id)) {
        exit(json_encode(['status' => 2]));
    }

    if (!is_worthy_specifically('k', $row->accused_admin_server_id)) {
        exit(json_encode(['status' => 2]));
    }

    $STH = $pdo->prepare('UPDATE complaints SET sentence=:sentence, judge_id=:judge_id, have_answer=:have_answer WHERE id = :id LIMIT 1');
    $STH->execute(['sentence' => $sentence, 'judge_id' => $_SESSION['id'], 'have_answer' => 1, 'id' => $id]);

    incNotifications();

    $noty = close_complaint_noty($id);
    $letter = close_complaint_letter($id, $full_site_host);

    send_noty($noty, $row->author_id, 1);
    if (1 == $row->author_email_notice) {
        sendmail($row->author_email, $letter['subject'], $letter['message'], $pdo);
    }

    if (!empty($row->accused_id)) {
        send_noty($noty, $row->accused_id, 1);
        if (1 == $row->accused_email_notice) {
            sendmail($row->accused_email, $letter['subject'], $letter['message'], $pdo);
        }
    }

    exit(json_encode(['status' => 1, 'answer' => Complaints::getComplaintSentenceText($sentence)]));
}

exit(json_encode(['status' => 2]));
