<?php

use GameCMS\Integrations\Integrations;
use GameCMS\Repositories\ServerRepository;
use GameCMS\Services\BansService;
use GameCMS\Services\ServersService;
use xPaw\SourceQuery\SourceQuery;

include_once __DIR__.'/../inc/start.php';

include_once __DIR__.'/../inc/protect.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

if (isset($_POST['admin_login'])) {
    if (!validateCaptcha($_POST['captcha'])) {
        exit('<p class="text-danger">Неверно введена капча!</p>');
    }

    $password = check($_POST['password'], null);

    if (empty($password)) {
        exit('<p class="text-danger">Вы ввели не всю информацию!</p>');
    }

    $U = new Users();

    $ip = get_ip();

    $invalid_auths = $U->check_to_invalid_auth($ip);
    if ($invalid_auths > 2) {
        log_error('admin-auth: Блокировка за неправильный ввод паролей');

        exit('<p class="text-danger">Вы заблокированы на 15 минут. Попробуйте позже.</p>');
    }

    $password = Users::convert_password($password, $conf->salt);

    if ($password != $conf->password) {
        $invalid_auths = $U->up_invalid_auths($ip);

        log_error('admin-auth: Попытка: '.$invalid_auths.'/3. Введенные данные неверны');

        exit('<p class="text-danger">Попытка: '.$invalid_auths.'/3. Введенные данные неверны.</p>');
    }
    if ($invalid_auths) {
        $U->dell_invalid_auths($ip);
    }

    if (1 == $conf->ip_protect) {
        $SC->admin_ip = $ip;
    }

    $_SESSION['admin'] = 'yes';
    $_SESSION['admin_cache'] = $SC->get_admin_cache($password);

    write_log('Успешная авторизация в Админ Центре');

    exit('<script>reset_page();</script>');
}
if (isset($_POST['user_login'])) {
    $login = check($_POST['login'], null);
    $password = check($_POST['password'], null);

    if (empty($login) or empty($password)) {
        exit('<p class="text-danger">Вы ввели не всю информацию!</p>');
    }

    $U = new Users();

    $ip = get_ip();

    $invalid_auths = $U->check_to_invalid_auth($ip);
    if ($invalid_auths > 2) {
        log_error('user-auth: Блокировка за неправильный ввод паролей');

        exit('<p class="text-danger">Вы заблокированы на 15 минут. Попробуйте позже.</p>');
    }

    $password = Users::convert_password($password, $conf->salt);
    $user = $U->getUserByLoginPassword($login, $password);

    if (empty($user->id)) {
        $invalid_auths = $U->up_invalid_auths($ip);

        log_error('user-auth: Попытка: '.$invalid_auths.'/3. Введенные данные неверны');

        exit('<p class="text-danger">Попытка: '.$invalid_auths.'/3. Введенные данные неверны.</p>');
    }
    if ($invalid_auths) {
        $U->dell_invalid_auths($ip);
    }

    if (1 != $user->active) {
        exit('<p class="text-danger">Пожалуйста, активируйте аккаунт, инструкция выслана на Ваш E-mail!</p>');
    }

    $result = $U->auth_user(
        $SC,
        $user->protect,
        $user->password,
        $user->login,
        $user->id,
        $user->rights,
        $user->multi_account
    );

    if ($result['status']) {
        exit('<script>reset_page();</script>');
    }

    exit('<p class="text-danger">'.$result['response'].'</p>');
}
if (isset($_POST['registration'])) {
    if (!configs()->standard_registration) {
        exit('<p class="text-danger">Данный способ регистрации отключен!</p>');
    }

    if (!validateCaptcha($_POST['captcha'])) {
        exit('<p class="text-danger">Неверно введена капча!</p>');
    }

    $login = check($_POST['login'], null);
    $password = check($_POST['password'], null);
    $password2 = check($_POST['password2'], null);
    $email = check($_POST['email'], null);

    if (empty($login) or empty($password) or empty($password2) or empty($email)) {
        exit('<p class="text-danger">Вы ввели не всю информацию. Заполните все поля!</p>');
    }

    $U = new Users();

    if (!$U->check_to_flood($conf->captcha)) {
        exit('<p class="text-danger">Вы слишком часто регистрируете аккаунты!</p>');
    }
    if (!$U->check_login_length($login)) {
        exit('<p class="text-danger">Логин должен состоять не менее чем из 3 символов и не более чем из 30.</p>');
    }
    if (!$U->check_login_composition($login)) {
        exit('<p class="text-danger">В логине разрешается использовать только буквы и цифры.</p>');
    }
    if (!$U->check_login_busyness($login)) {
        exit('<p class="text-danger">Введенный Вами логин уже зарегистрирован!</p>');
    }

    if (!$U->check_password_length($password)) {
        exit('<p class="text-danger">Пароль должен состоять не менее чем из 6 символов и не более чем из 15.</p>');
    }
    if ($password != $password2) {
        exit('<p class="text-danger">Введенные пароли не совпадают</p>');
    }
    $password = Users::convert_password($password, $conf->salt);

    if (!$U->check_email($email)) {
        exit('<p class="text-danger">Неверно введен E-mail!</p>');
    }
    if (!$U->check_email_busyness($email)) {
        exit('<p class="text-danger">Введенный Вами E-mail уже зарегистрирован!</p>');
    }

    $user = $U->entry_user($login, $password, $email, $conf->conf_us);

    if (!empty($user->id)) {
        $answer = $U->after_registration_actions($SC, $conf->salt, $conf->name, $user->id, $full_site_host);

        if ('error' != $answer['message']) {
            echo '<p class="text-success">'.$answer['message'].'</p>';
            sendmail($email, $answer['letter']['subject'], $answer['letter']['message'], $pdo);
        }

        exit;
    }

    exit('<p class="text-danger">Ошибка! Вы не зарегистрированы</p>');
}
if (isset($_POST['send_new_pass'])) {
    if (!validateCaptcha($_POST['captcha'])) {
        exit('<p class="text-danger">Неверно введена капча!</p>');
    }

    $email = check($_POST['email'], null);
    if (empty($email)) {
        exit('<p class="text-danger">Укажите E-mail!</p>');
    }

    $U = new Users();

    if (!$U->check_email($email)) {
        exit('<p class="text-danger">Неверно введен е-mail!</p>');
    }

    if (!$U->check_email_busyness($email)) {
        $STH = $pdo->query("SELECT `id`, `email`, `login`, `password` FROM `users` WHERE email='{$email}' LIMIT 1");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();

        $STH = $pdo->query("SELECT `url` FROM `pages` WHERE `name`='recovery' LIMIT 1");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $page_url = $STH->fetch();

        $link = $full_site_host.$page_url->url.'?a='.$row->id.'&data='.md5($row->id.$conf->salt.$row->password.$row->email.date('Y-m-d'));

        incNotifications();
        $letter = recovery_check_letter($conf->name, $row->login, $link);
        sendmail($row->email, $letter['subject'], $letter['message'], $pdo);

        write_log('Выслано письмо для восстановления пароля: ID'.$row->id);
    }

    exit('<p class="text-success">Если Вы ввели верную почту, то на нее будет направлено письмо со ссылкой для восстановления пароля, она будет действительна в течение текущего дня.</p>');
}
if (isset($_POST['get_servers'])) {
    update_monitoring($pdo);
    $i = 0;

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $tpl->result['content'] = '';

    $STH = $pdo->query(
        'SELECT monitoring.*, servers.rcon FROM monitoring LEFT JOIN servers ON monitoring.sid=servers.id ORDER BY monitoring.id'
    );

    while ($row = $STH->fetch(PDO::FETCH_OBJ)) {
        if ($row->players_now > $row->players_max) {
            $row->players_now = $row->players_max;
        }
        if (0 != $row->players_max) {
            $percentage = $row->players_now / $row->players_max * 100;
        } else {
            $percentage = 0;
        }

        if ($percentage <= 25) {
            $color = 'info';
        } elseif ($percentage <= 50) {
            $color = 'success';
        } elseif ($percentage <= 75) {
            $color = 'warning';
        } elseif ($percentage <= 100) {
            $color = 'danger';
        }

        if (('0' != $row->map) and file_exists('../files/maps_imgs/'.$row->map.'.jpg')) {
            $map = '/files/maps_imgs/'.$row->map.'.jpg';
        } else {
            $map = '/files/maps_imgs/none.jpg';
        }

        if ('0' == $row->map) {
            $row->map = 'Не определено';
        }

        if ('0' == $row->name) {
            $row->name = 'Не определено';
        }

        if (
            1 == $row->rcon
            && is_auth()
            && is_worthy_specifically('v', $row->sid)
        ) {
            $serverCommands = new ServerCommands();
            $commands = $serverCommands->getServerManagementCommands($row->sid);

            foreach ($commands as $command) {
                $command->params = json_encode($serverCommands->getCommandParams($command->id));
            }
        } else {
            $commands = [];
        }

        ++$i;

        $tpl->load_template('elements/server.tpl');
        $tpl->set('{rcon}', $row->rcon);
        $tpl->set('{name}', $row->name);
        $tpl->set('{map_img}', $map);
        $tpl->set('{map_name}', $row->map);
        $tpl->set('{percentage}', $percentage);
        $tpl->set('{color}', $color);
        $tpl->set('{max}', $row->players_max);
        $tpl->set('{now}', $row->players_now);
        $tpl->set('{address}', $row->address);
        $tpl->set('{ip}', $row->ip);
        $tpl->set('{port}', $row->port);
        $tpl->set('{id}', $row->sid);
        $tpl->set('{template}', get_template());
        $tpl->set('{game}', $row->game);
        $tpl->set('{i}', $i);
        $tpl->compile('content');
        $tpl->clear();

        $tpl->show($tpl->result['content']);
        $tpl->result['content'] = '';
    }

    if (0 == $i) {
        exit(tableRowError('Серверов нет'));
    }

    $tpl->global_clear();

    exit;
}
if (isset($_POST['get_players'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $STH = $pdo->query("SELECT `id`, `ip`, `port`, `rcon`, game FROM `servers` WHERE `id`='{$id}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();

    $STH = $pdo->query('SELECT `mon_api`, `mon_key` FROM `config__secondary` LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $conf2 = $STH->fetch();
    if (1 == $conf2->mon_api) {
        $players = @file_get_contents(
            getMonitoringUrl().'players-info.php?key='.$conf2->mon_key
                .'&ip='.$row->ip
                .'&port='.$row->port
                .'&version=2'
        );
        if (isset($players) and ('403' != $players)) {
            $players = unserialize($players);
        } else {
            $players = 0;
        }
    } else {
        try {
            $SourceQuery = new SourceQuery();
            $SourceQuery->Connect(
                $row->ip,
                $row->port,
                getConfigAdditional('monitoringTimeOut', 1),
                ServersService::isCS16($row->game) ? SourceQuery::GOLDSOURCE : SourceQuery::SOURCE
            );
            $players = $SourceQuery->GetPlayers();
            $SourceQuery->Disconnect();
        } catch (Exception $e) {
            $players = 0;
        }
    }

    $i = 0;
    if ($players) {
        $GD = new GetData($pdo);

        $tpl = new Template();
        $tpl->dir = '../templates/'.get_template().'/tpl/';

        $serverCommands = new ServerCommands();
        $commands = $serverCommands->getActionOnPlayersCommands($row->id);

        if (!empty($commands)) {
            foreach ($commands as $command) {
                $command->params = json_encode($serverCommands->getCommandParams($command->id));
            }
        } else {
            $commands = [];
        }

        usort($players, function ($a, $b) {
            return $a['Frags'] > $b['Frags'] ? -1 : 1;
        });

        foreach ($players as $player) {
            ++$i;

            $playerName = clean($player['Name'], null);

            if ($playerProfile = $GD->get_gamer_profile($player['Name'], '')) {
                $playerName = $playerProfile;
            }

            $tpl->load_template('elements/server_player.tpl');
            $tpl->set('{i}', $i);
            $tpl->set('{name}', $playerName);
            $tpl->set('{frags}', intval($player['Frags']));
            $tpl->set('{time}', (0 == $player['Time']) ? $player['Time'] : expand_seconds2($player['Time']));
            $tpl->set('{server_rcon}', $row->rcon);
            $tpl->set('{server_id}', $row->id);
            $tpl->set('{coded_nick}', '"'.base64_encode($player['Name']).'"');
            $tpl->compile('content');
            $tpl->clear();

            $tpl->show($tpl->result['content']);
            $tpl->result['content'] = '';
        }

        $tpl->global_clear();
    } else {
        exit(tableRowError('Нет игроков онлайн'));
    }

    exit;
}
if (isset($_POST['get_admin_info'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $i = 0;
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $tpl->result['content'] = '';

    $STH = $pdo->prepare('SELECT `admins__services`.`id`, `services`.`name`, `admins__services`.`service`, `admins__services`.`bought_date`, `admins__services`.`ending_date`
		FROM `admins__services` LEFT JOIN `services` ON `admins__services`.`service` = `services`.`id` WHERE `admins__services`.`admin_id` = :admin_id');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':admin_id' => $id]);
    while ($row = $STH->fetch()) {
        ++$i;
        if (!empty($row->service)) {
            $name = $row->name;
        } else {
            $name = 'Неизвестно';
        }
        if ('0000-00-00 00:00:00' == $row->ending_date) {
            $left = 'Вечность';
            $color = 'success';
            $ending_date = 'Никогда';
        } else {
            $left = strtotime($row->ending_date) - time();
            if ($left > 60 * 60 * 24 * 5) {
                $color = 'success';
            } elseif ($left > 60 * 60 * 24) {
                $color = 'warning';
            } else {
                $color = 'danger';
            }
            $left = expand_seconds2($left, 2);
            $ending_date = expand_date($row->ending_date, 1);
        }
        if ('0000-00-00 00:00:00' != $row->bought_date) {
            $bought_date = expand_date($row->bought_date, 1);
        } else {
            $bought_date = 'Неизвестно';
        }
        $tpl->load_template('elements/admin_info.tpl');
        $tpl->set('{i}', $i);
        $tpl->set('{name}', $name);
        $tpl->set('{bought_date}', $bought_date);
        $tpl->set('{ending_date}', $ending_date);
        $tpl->set('{left}', $left);
        $tpl->set('{color}', $color);
        $tpl->compile('content');
        $tpl->clear();
    }
    $tpl->show($tpl->result['content']);
    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_new_comments'])) {
    $id = check($_POST['id'], 'int');
    $i = 0;

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $tpl->result['content'] = '';
    $STH = $pdo->query("SELECT news__comments.*, users.login, users.avatar, users.rights FROM news__comments LEFT JOIN users ON news__comments.user_id = users.id WHERE new_id = '{$id}' ORDER BY id DESC");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        $date = expand_date($row->date, 8);

        if (is_worthy('q')) {
            $dell = '<span onclick="dell_new_comment('.$row->id.');" tooltip="yes" data-placement="left" title="Удалить" class="m-icon icon-trash dell_message"></span>';
        } else {
            $dell = '';
        }
        ++$i;

        $gp = $users_groups[$row->rights];
        $tpl->load_template('elements/comment.tpl');
        $tpl->set('{id}', $row->id);
        $tpl->set('{user_id}', $row->user_id);
        $tpl->set('{login}', $row->login);
        $tpl->set('{avatar}', $row->avatar);
        $tpl->set('{text}', $row->text);
        $tpl->set('{dell}', $dell);
        $tpl->set('{date_full}', $date['full']);
        $tpl->set('{date_short}', $date['short']);
        $tpl->set('{gp_color}', $gp['color']);
        $tpl->set('{gp_name}', $gp['name']);
        $tpl->compile('content');
        $tpl->clear();
    }
    if (0 == $i) {
        echo '<span class="empty-element">Комментариев нет</span>';
    } else {
        $tpl->show($tpl->result['content']);
        $tpl->global_clear();
    }

    exit;
}
if (isset($_POST['load_users_comments'])) {
    $id = check($_POST['id'], 'int');
    $load_val = check($_POST['load_val'], 'int');
    if (empty($load_val)) {
        $load_val = 1;
    }

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $start = ($load_val - 1) * 20;
    $end = 20;
    $i = $start;
    $i2 = 0;
    $tpl->result['content'] = '';
    $STH = $pdo->query("SELECT users__comments.*, users.login, users.avatar, users.rights FROM users__comments LEFT JOIN users ON users__comments.author = users.id WHERE user_id = '{$id}' ORDER BY id DESC LIMIT ".$start.', '.$end);
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        $date = expand_date($row->date, 8);
        if ((isset($_SESSION['id']) and $_SESSION['id'] == $id) or is_worthy('y')) {
            $dell = '<span onclick="dell_user_comment('.$row->id.');" tooltip="yes" data-placement="left" title="Удалить" class="m-icon icon-trash dell_message"></span>';
        } else {
            $dell = '';
        }
        ++$i;
        ++$i2;
        $gp = $users_groups[$row->rights];

        $tpl->load_template('elements/comment.tpl');
        $tpl->set('{gp_color}', $gp['color']);
        $tpl->set('{gp_name}', $gp['name']);
        $tpl->set('{id}', $row->id);
        $tpl->set('{user_id}', $row->author);
        $tpl->set('{login}', $row->login);
        $tpl->set('{avatar}', $row->avatar);
        $tpl->set('{text}', $row->text);
        $tpl->set('{dell}', $dell);
        $tpl->set('{date_full}', $date['full']);
        $tpl->set('{date_short}', $date['short']);
        $tpl->compile('content');
        $tpl->clear();
    }

    $tpl->show($tpl->result['content']);
    $tpl->global_clear();

    if (($load_val > 0) and ($i2 > 19)) {
        ++$load_val;

        exit('<div id="loader'.$load_val.'"><span class="empty-element" onclick="load_users_comments(\''.$id.'\',\''.$load_val.'\');">Подгрузить записи</span></div>');
    }
    if (0 == $start and 0 == $i2) {
        exit('<div id="loader'.$load_val.'"><span class="empty-element">Сообщений не найдено</span></div>');
    }
    if (($load_val > 0) and ($i2 < 20)) {
        exit;
    }

    exit;
}
if (isset($_POST['search_login'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);

    if (empty($_POST['login'])) {
        $tpl->show($GD->users($_POST['start'], $_POST['group']));
    } else {
        $tpl->show($GD->search_login($_POST['login'], $_POST['group']));
    }
    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_ban_comments'])) {
    $id = check($_POST['id'], 'int');
    $i = 0;

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl';
    $tpl->result['content'] = '';
    $STH = $pdo->query("SELECT `bans__comments`.*, `bans`.`server`, `users`.`login`, `users`.`avatar`, `users`.`rights` FROM `bans__comments` 
		LEFT JOIN `users` ON `bans__comments`.`user_id` = `users`.`id` 
		LEFT JOIN `bans` ON `bans__comments`.`ban_id` = `bans`.`id` 
		WHERE `bans__comments`.`ban_id` = '{$id}' ORDER BY `bans__comments`.`id` DESC");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        $tpl->load_template('/elements/comment.tpl');

        $gp = $users_groups[$row->rights];
        $date = expand_date($row->date, 8);
        if (is_worthy_specifically('o', $row->server)) {
            $dell = '<span onclick="dell_ban_comment('.$row->id.');" tooltip="yes" data-placement="left" title="Удалить" class="m-icon icon-trash dell_message"></span>';
        } else {
            $dell = '';
        }
        ++$i;

        $tpl->set('{id}', $row->id);
        $tpl->set('{user_id}', $row->user_id);
        $tpl->set('{login}', $row->login);
        $tpl->set('{avatar}', $row->avatar);
        $tpl->set('{text}', $row->text);
        $tpl->set('{dell}', $dell);
        $tpl->set('{date_full}', $date['full']);
        $tpl->set('{date_short}', $date['short']);
        $tpl->set('{gp_color}', $gp['color']);
        $tpl->set('{gp_name}', $gp['name']);
        $tpl->compile('content');
        $tpl->clear();
    }
    if (0 == $i) {
        echo '<span class="empty-element">Комментариев нет</span>';
    } else {
        $tpl->show($tpl->result['content']);
        $tpl->global_clear();
    }

    exit;
}
if (isset($_POST['search_ban'])) {
    $bid = check($_POST['ban'], 'int');
    $serverId = check($_POST['server'], 'int');

    if (empty($bid) or empty($serverId)) {
        exit;
    }

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit;
    }

    $bansService = new BansService();
    $integrator = $bansService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit;
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit;
    }

    $address = "{$server->ip}:{$server->port}";

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $table = set_prefix($server->db_prefix, 'bans');

        $STH = $connection->prepare(
            "SELECT 
				0 as admin_user_id,
				{$table}.* 
			FROM {$table} 
			WHERE server_ip = '{$address}' AND bid = :bid
			LIMIT 1"
        );
        $STH->execute([':bid' => $bid]);
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'servers');

        $STH = $connection->query("SELECT sid FROM {$table} WHERE ip='{$server->ip}' AND port={$server->port} LIMIT 1");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();

        $sid = $row->sid;
        $table1 = set_prefix($server->db_prefix, 'bans');
        $table2 = set_prefix($server->db_prefix, 'admins');
        $STH = $connection->prepare(
            "SELECT 
				{$table1}.bid,
			    {$table1}.unban_type,
			    {$table1}.ban_closed,
			    {$table1}.ip AS player_ip,
			    {$table1}.RemoveType AS expired,
			    {$table1}.authid AS player_id,
			    {$table1}.name AS player_nick,
			    {$table1}.created AS ban_created,
			    {$table1}.length AS ban_length,
			    {$table1}.reason AS ban_reason,
			    {$table2}.user AS admin_nick,
			    {$table2}.nick AS admin_primary_nick,
			    {$table2}.authid AS admin_id,
				{$table2}.user_id AS admin_user_id  
			FROM {$table1} 
				LEFT JOIN {$table2} ON {$table1}.aid = {$table2}.aid 
			WHERE ({$table1}.sid = {$sid} OR {$table1}.sid = 0) 
			  	AND ({$table1}.bid = :bid)
			LIMIT 1"
        );
        $STH->execute([':bid' => $bid]);
    }

    if (Integrations::IKS == $server->type) {
        $table1 = set_prefix($server->db_prefix, 'bans');
        $table2 = set_prefix($server->db_prefix, 'admins');
        $STH = $connection->prepare(
            "SELECT 
					{$table1}.id as bid,
					{$table1}.unban_type,
					{$table1}.ban_closed,
					{$table1}.ip AS player_ip,
					{$table1}.Unbanned AS expired,
					{$table1}.sid AS player_id,
					{$table1}.name AS player_nick,
					{$table1}.created AS ban_created,
					{$table1}.time AS ban_length,
					{$table1}.reason AS ban_reason,
					{$table1}.adminName AS admin_nick,
					{$table2}.name AS admin_primary_nick,
					{$table2}.sid AS admin_id,
					{$table2}.user_id AS admin_user_id  
				FROM {$table1} 
					LEFT JOIN {$table2} ON {$table1}.adminsid = {$table2}.sid 
				WHERE ({$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0) 
				  AND ({$table1}.id = :bid) 
				LIMIT 1"
        );
        $STH->execute([':bid' => $bid]);
    }

    $row = $STH->fetchObject();

    if (empty($row->bid)) {
        exit('<p>Бан не найден</p>');
    }

    $steamIdOperations = new SteamIDOperations();
    $getData = new GetData();

    $class = '';

    $banLength = $row->ban_length;
    $banCreated = $row->ban_created;
    $banEndTime = 0;
    $banTimeTitle = '';

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $banLength *= 60;
        $banEndTime = $banCreated + $banLength;

        if (-2 == $row->unban_type) {
            $banTimeTitle = 'Куплен разбан';
            $class = 'success';
        } elseif (-1 == $row->unban_type || 1 == $row->expired) {
            $banTimeTitle = 'Разбанен';
            $class = 'success';
        } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
            $banTimeTitle = 'Срок истек';
            $class = 'success';
        } elseif (0 == $banLength) {
            $banTimeTitle = 'Никогда';
            $class = 'danger';
        } else {
            $banTimeTitle = expand_date($banEndTime);
        }
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $banEndTime = $banCreated + $banLength;

        if (-2 == $row->unban_type) {
            $banTimeTitle = 'Куплен разбан';
            $class = 'success';
        } elseif (-1 == $row->unban_type || 'U' == $row->expired) {
            $banTimeTitle = 'Разбанен';
            $class = 'success';
        } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time()) || 'E' == $row->expired) {
            $banTimeTitle = 'Срок истек';
            $class = 'success';
        } elseif (0 == $banLength) {
            $banTimeTitle = 'Никогда';
            $class = 'danger';
        } else {
            $banTimeTitle = expand_date($banEndTime);
        }
    }

    if (Integrations::IKS == $server->type) {
        $row->admin_id = $steamIdOperations->GetSteamID32($row->admin_id);
        $row->player_id = $steamIdOperations->GetSteamID32($row->player_id);

        $banEndTime = $banCreated + $banLength;

        if (-2 == $row->unban_type) {
            $banTimeTitle = 'Куплен разбан';
            $class = 'success';
        } elseif (-1 == $row->unban_type || 1 == $row->expired) {
            $banTimeTitle = 'Разбанен';
            $class = 'success';
        } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
            $banTimeTitle = 'Срок истек';
            $class = 'success';
        } elseif (0 == $banLength) {
            $banTimeTitle = 'Никогда';
            $class = 'danger';
        } else {
            $banTimeTitle = expand_date($banEndTime);
        }
    }

    $adminNick = get_ban_admin_nick($row->admin_nick, $row->admin_primary_nick ?? null, $server->name, $server->type);

    if ($adminProfile = $getData->get_gamer_profile($adminNick, $row->admin_id, $row->admin_user_id)) {
        $adminNick = $adminProfile;
    }

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $tpl->load_template('elements/search_ban.tpl');
    $tpl->set('{bid}', $row->bid);
    $tpl->set('{player_ip}', isNeedHidePlayerId() ? hidePlayerId($row->player_ip) : $row->player_ip);
    $tpl->set('{player_id}', isNeedHidePlayerId() ? hidePlayerId($row->player_id) : $row->player_id);
    $tpl->set('{player_nick}', check($row->player_nick));
    $tpl->set('{admin_nick}', $adminNick);
    $tpl->set('{ban_reason}', check($row->ban_reason));
    $tpl->set('{color}', $class);
    $tpl->set('{time}', $banTimeTitle);
    $tpl->set('{ban_created}', expand_date(date('Y-m-d H:i:s', $banCreated), 7));
    $tpl->set('{ban_length}', expand_seconds2($banLength, 2));
    $tpl->set('{address}', $address);
    $tpl->set('{server_name}', $server->name);
    $tpl->compile('content');
    $tpl->clear();

    $tpl->show($tpl->result['content']);
    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_stats'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);
    if (empty($_POST['name'])) {
        $tpl->show($GD->stats($_POST['start'], $_POST['server']));
    } else {
        $tpl->show($GD->stats($_POST['start'], $_POST['server'], 0, $_POST['name']));
    }

    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_wstats'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);
    $tpl->show($GD->stats_details($_POST['server'], $_POST['id'], 'weapons'));
    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_mstats'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);
    $tpl->show($GD->stats_details($_POST['server'], $_POST['id'], 'maps'));
    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_banlist'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);
    if (empty($_POST['name'])) {
        $tpl->show($GD->banlist($_POST['start'], $_POST['server']));
    } else {
        $tpl->show($GD->banlist($_POST['start'], $_POST['server'], 0, $_POST['name']));
    }

    $tpl->global_clear();

    exit;
}
if (isset($_POST['load_muts'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $GD = new GetData($pdo, $tpl);
    if (empty($_POST['name'])) {
        $tpl->show($GD->mutlist($_POST['start'], $_POST['server']));
    } else {
        $tpl->show($GD->mutlist($_POST['start'], $_POST['server'], 0, $_POST['name']));
    }

    $tpl->global_clear();

    exit;
}
if (isset($_POST['get_services'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $service = 0;
    tpl()->result['options'] = '';

    $STH = $pdo->query("SELECT id,name,rights,sale FROM services WHERE server = '{$id}' ORDER BY trim");
    while ($row = $STH->fetch(PDO::FETCH_OBJ)) {
        if (2 != $row->sale) {
            if (empty(tpl()->result['options'])) {
                $service = $row->id;
            }

            tpl()->compileOption($row->name, $row->id, 0, 'service');
        }
    }

    exit(
        json_encode(
            [
                'status' => 1,
                'data' => tpl()->getShow(tpl()->result['options']),
                'service' => $service,
            ]
        )
    );
}
if (isset($_POST['get_tarifs'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $STH = $pdo->query("SELECT `services`.`text`, `services`.`discount` AS `service_dicount`,`servers`.`discount` FROM `services` LEFT JOIN `servers` ON `services`.`server`=`servers`.`id` WHERE `services`.`id` = '{$id}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    $text = $row->text;

    $service_discount = $row->service_dicount;
    $server_discount = $row->discount;

    $STH = $pdo->query('SELECT discount FROM config__prices LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $disc = $STH->fetch();
    $discount = $disc->discount;

    tpl()->result['options'] = '';
    $STH = $pdo->query("SELECT id,price,time,discount FROM services__tarifs WHERE service = '{$id}' ORDER BY price");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    while ($row = $STH->fetch()) {
        if (0 == $row->time) {
            $time = 'Навсегда';
        } else {
            $time = $row->time.' дня(ей)';
        }

        if (isset($user->proc)) {
            $user_proc = $user->proc;
        } else {
            $user_proc = 0;
        }

        $proc = calculate_discount($server_discount, $discount, $user_proc, $service_discount, $row->discount);
        $price = calculate_price($row->price, $proc);

        tpl()->compileOption(
            ($price != $row->price)
                ? $time.' - '.$price.' '.$messages['RUB'].' (с учетом скидки в '.$proc.'%)'
                : $time.' - '.$price.' '.$messages['RUB'],
            $row->id,
            0,
            'tarif'
        );
    }

    exit(
        json_encode(
            [
                'status' => 1,
                'data' => tpl()->getShow(tpl()->result['options']),
                'text' => $text,
            ]
        )
    );
}
if (isset($_POST['get_server_store'])) {
    $id = check($_POST['id'], 'int');
    $type = check($_POST['type'], 'int');

    if (empty($id)) {
        exit;
    }
    if (empty($type)) {
        $type = 0;
    }

    $STH = $pdo->query("SELECT `monitoring`.*, `servers`.`rcon`,`servers`.`binds`,`servers`.`type` FROM `monitoring` LEFT JOIN `servers` ON `monitoring`.`sid`=`servers`.`id` WHERE `monitoring`.`sid`='{$id}'");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        $STH = $pdo->prepare('SELECT `id`,`ip`,`port`,`name`,`address`,`rcon`,`game`,`binds`,`type` FROM `servers` WHERE `id`=:id LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':id' => $id]);
        $row = $STH->fetch();
        $row->map = 0;
        $row->name = '0';
        $row->players_max = 0;
        $row->players_now = 0;
        $row->sid = $row->id;
    }

    if (0 == $row->type || 1 == $row->type) {
        $disp = 'disp-n';
    } else {
        $disp = '';
    }

    if (('0' != $row->map) and file_exists('../files/maps_imgs/'.$row->map.'.jpg')) {
        $map = '/files/maps_imgs/'.$row->map.'.jpg';
    } else {
        $map = '/files/maps_imgs/none.jpg';
    }
    if ('0' == $row->map) {
        $row->map = 'Не определено';
    }
    if ('0' == $row->name) {
        $row->name = 'Не определено';
    }

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $tpl->load_template('elements/server_min.tpl');
    $tpl->set('{name}', $row->name);
    $tpl->set('{map_img}', $map);
    $tpl->set('{map_name}', $row->map);
    $tpl->set('{template}', get_template());
    $tpl->set('{max}', $row->players_max);
    $tpl->set('{now}', $row->players_now);
    $tpl->set('{ip}', $row->ip);
    $tpl->set('{port}', $row->port);
    $tpl->set('{id}', $row->sid);
    $tpl->set('{disp}', $disp);
    $tpl->set('{address}', $row->address);
    $tpl->set('{rcon}', $row->rcon);
    $tpl->compile('content');
    $tpl->clear();

    if (1 == $type) {
        $binds = explode(';', $row->binds);

        $binds_data = '';
        if ($binds[0]) {
            $binds_data .= "$('#store_type option[value=\"1\"]').removeAttr('disabled');";
            $binds_data .= "$('#store_type option[value=\"1\"]').attr('class', 'disp-b');";
        } else {
            $binds_data .= "$('#store_type option[value=\"1\"]').attr('disabled', '');";
            $binds_data .= "$('#store_type option[value=\"1\"]').attr('class', 'disp-n');";
        }
        if ($binds[1]) {
            $binds_data .= "$('#store_type option[value=\"2\"]').removeAttr('disabled');";
            $binds_data .= "$('#store_type option[value=\"2\"]').attr('class', 'disp-b');";
        } else {
            $binds_data .= "$('#store_type option[value=\"2\"]').attr('disabled', '');";
            $binds_data .= "$('#store_type option[value=\"2\"]').attr('class', 'disp-n');";
        }
        if ($binds[2]) {
            $binds_data .= "$('#store_type option[value=\"3\"]').removeAttr('disabled');";
            $binds_data .= "$('#store_type option[value=\"3\"]').attr('class', 'disp-b');";
        } else {
            $binds_data .= "$('#store_type option[value=\"3\"]').attr('disabled', '');";
            $binds_data .= "$('#store_type option[value=\"3\"]').attr('class', 'disp-n');";
        }

        $tpl->result['content'] .= '<script>change_store_bind_type(0);'.$binds_data.'</script>';
    }

    $tpl->show($tpl->result['content']);
    $tpl->global_clear();
}
if (isset($_POST['loadComplaintComments'])) {
    $id = check($_POST['id'], 'int');

    $STH = $pdo->prepare(
        'SELECT 
    				complaints__comments.*, 
    				complaints.accused_admin_server_id,
					users.login, 
					users.avatar, 
					users.rights 
				FROM 
				    complaints__comments 
						LEFT JOIN users ON complaints__comments.user_id = users.id 
						LEFT JOIN complaints ON complaints__comments.complaint_id = complaints.id 
				WHERE complaints__comments.complaint_id = :id 
				ORDER BY complaints__comments.id DESC'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);

    $i = 0;
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl';
    $tpl->result['content'] = '';

    while ($row = $STH->fetch()) {
        $tpl->load_template('/elements/comment.tpl');

        $gp = $users_groups[$row->rights];
        $date = expand_date($row->date, 8);
        if (is_worthy_specifically('u', $row->accused_admin_server_id)) {
            $dell = '<span onclick="removeComplaintComment('.$row->id.');" tooltip="yes" data-placement="left" title="Удалить" class="m-icon icon-trash dell_message"></span>';
        } else {
            $dell = '';
        }
        ++$i;

        $tpl->set('{id}', $row->id);
        $tpl->set('{user_id}', $row->user_id);
        $tpl->set('{login}', $row->login);
        $tpl->set('{avatar}', $row->avatar);
        $tpl->set('{text}', $row->text);
        $tpl->set('{dell}', $dell);
        $tpl->set('{date_full}', $date['full']);
        $tpl->set('{date_short}', $date['short']);
        $tpl->set('{gp_color}', $gp['color']);
        $tpl->set('{gp_name}', $gp['name']);
        $tpl->compile('content');
        $tpl->clear();
    }

    if (0 == $i) {
        echo '<span class="empty-element">Комментариев нет</span>';
    } else {
        $tpl->show($tpl->result['content']);
        $tpl->global_clear();
    }

    exit;
}
