<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Разблокирование счета.
	 * Если счет был заблокирован с помощью метода BlockAccountRequest или в личном кабинете пользователя, то для разблокирования счета нужно передать в запросе
	 * "ответ на секретный вопрос" и "платежный пароль" этого счета. Разблокировать счет может только тот пользователь (с тем же логином), который заблокировал счет.
	 * Если счет был заблокирован после ввода неверного платежного пароля (например, во время оплаты), то для разблокирования счета требуется только ответ на секретный вопрос.
	 * Unblock an account.
	 * 
 */
class UnblockAccountRequest extends AbstractAttributeObject
{
	
	/**
	 * Идентификатор счета.
	 * The identifier of the account.
	 * 
	 *
	 * @var long
	 */
	 public $id = null;

	/**
	 * Ответ на секретный вопрос (в разделе Безопасность).
	 * Answer to secret question (in Security).
	 * 
	 *
	 * @var string
	 */
	 public $secretAnswer = null;

	/**
	 * Платежный пароль.
	 * Платежный пароль требуется, если счет был заблокирован с помощью метода BlockAccountRequest или в личном кабинете пользователя.
	 * Если счет был заблокирован после ввода неверного платежного пароля, то этот элемент не требуется.
	 * Payment password.
	 * 
	 *
	 * @var AbstractAttributeObject
	 */
	 public $paymentPassword = null;

}
