<?php

global $protection;

if (!isset($protection)) {
    $protection = 1;
}

require_once __DIR__.'/autoloader.php';

require_once __DIR__.'/db.php';

require_once __DIR__.'/config.php';

require_once __DIR__.'/dictionary.php';

require_once __DIR__.'/config_additional.php';

global $host;

$SC = new SessionsCookies(configs()->salt, $host);
$token = $SC->set_token();

if (empty($_SERVER['HTTP_USER_AGENT'])) {
    $_SERVER['HTTP_USER_AGENT'] = 'undefined';
}

if (isset($_COOKIE['id'], $_COOKIE['cache'])) {
    $_SESSION['cache'] = clean($_COOKIE['cache']);
    $_SESSION['id'] = clean($_COOKIE['id'], 'int');
} else {
    $SC->clean_user_session();
}

if (is_admin()) {
    if (1 == configs()->ip_protect) {
        $SC->admin_ip = get_ip();
    }

    if ($_SESSION['admin_cache'] != $SC->get_admin_cache(configs()->password)) {
        $SC->clean_admin_session();
    }
} else {
    $SC->clean_admin_session();
}

$users_groups = get_groups();

if (is_auth()) {
    $user = Users::getUserData($_SESSION['id']);

    if ($user && 1 == $user->protect) {
        $SC->ip = get_ip();
    }

    if (
        !$user
        || ($_SESSION['cache'] != $SC->get_cache($user->password))
        || (1 == $user->dell)
        || is_worthy('z')
    ) {
        require_once __DIR__.'/../modules/exit/index.php';
    }

    $_SESSION['rights'] = $user->rights;
    $_SESSION['stickers'] = $user->stickers;

    if (is_worthy('x')) {
        $ban = true;

        require_once __DIR__.'/../modules/exit/index.php';
    }
} else {
    $_SESSION['stickers'] = 0;
}
