<?php

namespace GameCMS\Integrations\Admins;

use GameCMS\Models\Server;

trait AdminSystemHelpers
{
    public function notyServer(Server $server): void
    {
        try {
            (new \OurSourceQuery())->reloadAdmins($server->id);
        } catch (\Exception $e) {
            log_error('noty_server: '.$e->getMessage());
        }
    }

    private function insertAdmin(int $serverId, array $admin, array $services)
    {
        if (empty($admin['pass'])) {
            $admin['pass'] = '';
        }

        if (empty($admin['pass_md5'])) {
            $admin['pass_md5'] = '';
        }

        if (empty($admin['user_id'])) {
            $admin['user_id'] = 0;
        }

        pdo()
            ->prepare(
                'INSERT INTO admins (name,pass,pass_md5,type,server,user_id) values (:name, :pass, :pass_md5, :type, :server, :user_id)'
            )
            ->execute(
                [
                    'server' => $serverId,
                    'name' => $admin['name'],
                    'pass' => $admin['pass'],
                    'pass_md5' => $admin['pass_md5'],
                    'type' => $admin['type'],
                    'user_id' => $admin['user_id'],
                ]
            );

        $STH = pdo()->prepare('SELECT id FROM admins WHERE name=:name and server=:server LIMIT 1');
        $STH->execute([':name' => $admin['name'], ':server' => $serverId]);
        $row = $STH->fetchObject();

        for ($j = 0; $j < count($services); ++$j) {
            if (empty($services[$j]['rights_und'])) {
                $services[$j]['rights_und'] = '';
            }

            if (empty($services[$j]['immunity_und'])) {
                $services[$j]['immunity_und'] = 0;
            }

            if (empty($services[$j]['sb_group_und'])) {
                $services[$j]['sb_group_und'] = '';
            }

            pdo()
                ->prepare(
                    'INSERT INTO admins__services (admin_id,service,service_time,bought_date,ending_date,irretrievable,rights_und,immunity_und,sb_group_und) values (:admin_id, :service, :service_time, :bought_date, :ending_date, :irretrievable, :rights_und, :immunity_und, :sb_group_und)'
                )
                ->execute(
                    [
                        ':admin_id' => $row->id,
                        ':service' => $services[$j]['service'],
                        ':service_time' => $services[$j]['service_time'],
                        ':bought_date' => $services[$j]['bought_date'],
                        ':ending_date' => $services[$j]['ending_date'],
                        ':irretrievable' => $services[$j]['irretrievable'],
                        ':rights_und' => $services[$j]['rights_und'],
                        ':immunity_und' => $services[$j]['immunity_und'],
                        ':sb_group_und' => $services[$j]['sb_group_und'],
                    ]
                );
        }
    }

    private function getAdminServices(int $admin_id): array
    {
        $services = [];
        $i = 0;

        $STH = pdo()->prepare(
            'SELECT 
					    admins__services.id, 
					    admins__services.service, 
					    admins__services.irretrievable, 
						admins__services.ending_date, 
					    admins__services.rights_und, 
					    admins__services.sb_group_und, 
					    admins__services.immunity_und, 
					    admins__services.service_time, 
					    admins__services.bought_date, 
					    services.sb_group, 
					    services.immunity, 
					    services.rights 
					FROM admins__services 
						LEFT JOIN services ON admins__services.service = services.id 
					WHERE admins__services.admin_id = :admin_id'
        );
        $STH->execute([':admin_id' => $admin_id]);

        while ($row = $STH->fetchObject()) {
            $services[$i]['service'] = $row->service;
            $services[$i]['service_time'] = $row->service_time;
            $services[$i]['bought_date'] = $row->bought_date;
            $services[$i]['ending_date'] = $row->ending_date;
            $services[$i]['irretrievable'] = $row->irretrievable;

            $services[$i]['rights'] = $row->rights;
            $services[$i]['sb_group'] = $row->sb_group;
            $services[$i]['immunity'] = $row->immunity;
            $services[$i]['rights_und'] = $row->rights_und;
            $services[$i]['sb_group_und'] = $row->sb_group_und;
            $services[$i]['immunity_und'] = $row->immunity_und;

            $services[$i]['expired'] = strtotime($row->ending_date);
            ++$i;
        }

        if (1 == $i && 0 == $services[0]['service']) {
            $services[0]['rights'] = $services[0]['rights_und'];
            $services[0]['sb_group'] = $services[0]['sb_group_und'];
            $services[0]['immunity'] = $services[0]['immunity_und'];
        }

        return $services;
    }

    private function getAdminRights(array $services): array
    {
        $count = count($services);
        $rights['flags'] = '';
        $rights['sb_group'] = '';

        for ($i = 0; $i < $count; ++$i) {
            if (!empty($services[$i]['rights_und']) and 'none' != $services[$i]['rights_und']) {
                $rights['flags'] .= $services[$i]['rights_und'];
            } else {
                $rights['flags'] .= $services[$i]['rights'];
            }
            if (!empty($services[$i]['sb_group'])) {
                $rights['sb_group'] = $services[$i]['sb_group'];
            }
        }

        $rights['flags'] = trim($rights['flags']);
        $rights['sb_group'] = trim($rights['sb_group']);

        return $rights;
    }

    private function collectAdminRights(string $rights): string
    {
        $out_rights = '';
        $tmp = [];

        for ($a = 0; $a < strlen($rights); ++$a) {
            if (in_array($rights[$a], $tmp)) {
                continue;
            }
            $out_rights .= ($tmp[] = $rights[$a]);
        }

        return $out_rights;
    }

    private function collectAdminImmunity(array $services): int
    {
        $count = count($services);
        $immunity = 0;

        for ($i = 0; $i < $count; ++$i) {
            if ($services[$i]['immunity'] > $immunity) {
                $immunity = $services[$i]['immunity'];
            }
        }

        return trim($immunity);
    }

    private function collectAdminExpireDate(array $services): int
    {
        $count = count($services);
        $expired = 0;

        for ($i = 0; $i < $count; ++$i) {
            if ($services[$i]['expired'] > $expired) {
                $expired = $services[$i]['expired'];
            }
        }

        return trim($expired);
    }

    private function serializeAdminInfo(array $admin_services): string
    {
        $count = count($admin_services);

        if (1 == $count && 0 == $admin_services[0]['service']) {
            $admin_services = '';
        } else {
            for ($i = 0; $i < $count; ++$i) {
                unset($admin_services[$i]['rights'], $admin_services[$i]['sb_group'], $admin_services[$i]['immunity'], $admin_services[$i]['sb_group_und'], $admin_services[$i]['immunity_und'], $admin_services[$i]['expired']);
            }

            $admin_services = serialize($admin_services);
        }

        return $admin_services;
    }
}
