<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий параметры операции для выставления счета к оплате.
	 * Transaction parameters for creating an invoice.
	 * 
 */
class InvoiceRequestType extends Entity
{
	
	/**
	 * Номер счета плательщика.
	 * MONETA.RU account number of the payer.
	 * 
	 *
	 * @var string
	 */
	 public $payer = null;

	/**
	 * Номер счета получателя.
	 * Account number of the payee.
	 * 
	 *
	 * @var long
	 */
	 public $payee = null;

	/**
	 * Сумма.
	 * Invoice amount.
	 * 
	 *
	 * @var decimal
	 */
	 public $amount = null;

	/**
	 * Внешний номер операции.
	 * Merchant transaction ID.
	 * 
	 *
	 * @var string
	 */
	 public $clientTransaction = null;

	/**
	 * Описание операции.
	 * Transaction description or comments.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $description = null;

	/**
	 * Произвольный параметр.
	 * Custom parameter.
	 * 
	 *
	 * @var string
	 */
	 public $mnt_custom1 = null;

	/**
	 * Произвольный параметр.
	 * Custom parameter.
	 * 
	 *
	 * @var string
	 */
	 public $mnt_custom2 = null;

	/**
	 * Произвольный параметр.
	 * Custom parameter.
	 * 
	 *
	 * @var string
	 */
	 public $mnt_custom3 = null;

	/**
	 * Набор полей, которые необходимо сохранить в качестве атрибутов операции. Значения дат в формате dd.MM.yyyy HH:mm:ss.
	 * Для того чтобы провести прямое дебетование, следует передать атрибут с ключом "SUBSCRIBERID" и в значении указать ID подписчика.
	 * Прямое дебетование будет проведено, если ID подписчика указано верно, если пользователь разрешил проводить прямое дебетование,
	 * если указанная сумма есть на балансе пользователя. В данном случае деньги будут списаны со счета пользователя, в ответе на запрос
	 * в поле Статус будет указано INPROGRESS, зачисление денег на счет получателя будет проведено в асинхронном режиме.
	 * Если прямое дебетование не может быть проведено или во время его выполнения произойдет ошибка,
	 * то инвойс будет создан и в ответе на запрос в поле Статус будет указано CREATED.
	 * USERCONTACT - ссылка на оплату счета будет отправлена в письме или SMS (можно перечислить получателей через запятую).
	 * Key-value pairs that will be saved as transaction attributes. For dates, use the following format: dd.MM.yyyy HH:mm:ss.
	 * To initiate direct debit, pass the "SUBSCRIBERID" attribute with corresponding subscriber id in the value.
	 * The direct debit will be processed if subscriber id is specified, the direct debit processing is permitted by user and user has enough funds on his account.
	 * If the direct debit is processed successfully, user's account is debited, the transaction status reported in the response is INPROGRESS, crediting the payee's account starts asynchronously.
	 * If the direct debit can't be processed or an error occures during the processing, the invoice is left registered and the transaction status is CREATED.
	 * USERCONTACT - payment link will be sent via e-mail or SMS (comma separated recepients).
	 * 
	 *
	 * @var OperationInfo
	 */
	 public $operationInfo = null;

}
