<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий суммы и комиссии в предварительном расчете операции.
	 * Transaction amount and estimated fees for a transaction.
	 * 
 */
class ForecastTransactionResponseType
{
	
	/**
	 * Номер счета плательщика.
	 * Account number of the payer.
	 * 
	 *
	 * @var long
	 */
	 public $payer = null;

	/**
	 * Валюта счета плательщика.
	 * Currency of the payer's account.
	 * 
	 *
	 * @var string
	 */
	 public $payerCurrency = null;

	/**
	 * Сумма к списанию.
	 * The amount to be transferred from the payer's account.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerAmount = null;

	/**
	 * Комиссия списания средств.
	 * Transaction fee to the payer.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerFee = null;

	/**
	 * Сумма, на которую изменится счет плательщика после проведения операции.
	 * Для чтения этого свойства в запросе необходимо выставлять атрибут version равный или больше VERSION_4.
	 * Payer's account balance changes.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_4.
	 * 
	 *
	 * @var decimal
	 */
	 public $payerAccountTotal = null;

	/**
	 * Номер счета получателя.
	 * Payee's account number.
	 * 
	 *
	 * @var long
	 */
	 public $payee = null;

	/**
	 * Валюта счета получателя.
	 * Currency of the payee's account.
	 * 
	 *
	 * @var string
	 */
	 public $payeeCurrency = null;

	/**
	 * Сумма к зачислению.
	 * The amount to be transferred to the payee's account.
	 * 
	 *
	 * @var decimal
	 */
	 public $payeeAmount = null;

	/**
	 * Комиссия зачисления средств.
	 * Transaction fee to the payee.
	 * 
	 *
	 * @var decimal
	 */
	 public $payeeFee = null;

	/**
	 * Сумма, на которую изменится счет получателя после проведения операции.
	 * Для чтения этого свойства в запросе необходимо выставлять атрибут version равный или больше VERSION_4.
	 * Payee's account balance changes.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_4.
	 * 
	 *
	 * @var decimal
	 */
	 public $payeeAccountTotal = null;

	/**
	 * Название счета плательщика.
	 * Payer's account alias.
	 * 
	 *
	 * @var string
	 */
	 public $payerAlias = null;

	/**
	 * Название счета получателя.
	 * Payee's account alias.
	 * 
	 *
	 * @var string
	 */
	 public $payeeAlias = null;

	/**
	 * Дополнительные атрибуты. Пока не используются.
	 * Для чтения этого свойства в запросе необходимо выставлять атрибут version равный или больше VERSION_4.
	 * Additional parameters.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_4.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $attribute = null;

	/**
	 * Дополнительные атрибуты. Пока не используются.
	 * Для чтения этого свойства в запросе необходимо выставлять атрибут version равный или больше VERSION_4.
	 * Additional parameters.
	 * MONETA.RU returns this element only if you set the version attribute of your request to VERSION_4.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAttribute(KeyValueAttribute $item)
	{
		$this->attribute[] = $item;
	}

}
