<?php

if (
    version_compare(PHP_VERSION, '7.4', '<')
    || version_compare(PHP_VERSION, '8.4', '>=')
) {
    exit('Для работы GameCMS необходим PHP версии 7.4 - 8.3');
}

foreach (['GD', 'mbstring', 'IonCube Loader', 'json', 'curl', 'bcmath'] as $module) {
    if (!extension_loaded($module)) {
        exit('Для работы GameCMS необходим PHP модуль '.$module);
    }
}

if (function_exists('ioncube_loader_iversion')) {
    $ioncubeVersion = ioncube_loader_iversion();

    if (PHP_MAJOR_VERSION === 7 && ($ioncubeVersion / 10000) < 12) {
        exit('Для работы GameCMS необходим PHP модуль IonCube Loader версии 12 и выше');
    }

    if (PHP_MAJOR_VERSION === 8 && ($ioncubeVersion / 10000) < 13) {
        exit('Для работы GameCMS необходим PHP модуль IonCube Loader версии 13 и выше');
    }
}

if (file_exists(__DIR__.'/inc/db.php')) {
    $coreFile = __DIR__.'/inc/core'.PHP_MAJOR_VERSION.'.'.PHP_MINOR_VERSION.'.php';

    require $coreFile;
} else {
    if (file_exists(__DIR__.'/modules/install/index.php')) {
        require __DIR__.'/modules/install/index.php';
    } else {
        exit('Инсталлятор не найден');
    }
}
