<?php

$safe_mode = 1; // безопасный режим - 1

ini_set('display_errors', (isDevMode() && 1 == configs()->display_errors) ? 1 : 0);
error_reporting(E_ALL);
date_default_timezone_set($conf->time_zone ?? 'Europe/Moscow');

global $protection;

if (1 == $protection) {
    header('X-Frame-Options: DENY');
    header('X-XSS-Protection: 1; mode=block');
}

$protocol = 'http';
if (empty($conf->protocol) || 1 == $conf->protocol) {
    $protocol = $_SERVER['HTTP_SCHEME'] ?? (
        (
            (isset($_SERVER['HTTPS']) && 'off' != $_SERVER['HTTPS'])
            || 443 == $_SERVER['SERVER_PORT']
        )
            ? 'https'
            : 'http'
    );
} elseif (3 == $conf->protocol) {
    $protocol = 'https';
}


$inactive_time = 900;

$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http';

$host = $_SERVER['HTTP_HOST'] ?? 'localhost';

$full_site_host = $protocol . '://' . $host . '/';