<?php

namespace GameCMS\Statistics;

use GameCMS\Models\Server;

abstract class DatabasedIntegration
{
    public function getStorageConnection(Server $server): array
    {
        $connection = db_connect($server->st_db_host, $server->st_db_db, $server->st_db_user, $server->st_db_pass);

        if (!$connection) {
            return [null, error('Не удалось подключиться к базе данных сервера')];
        }

        set_names($connection, $server->st_db_code);

        return [$connection, null];
    }
}
