<?php

namespace GameCMS\Statistics;

use GameCMS\Models\Server;

class CMSStatsMysqlIntegration extends ArmyRanksUltimateIntegration implements StatisticIntegration
{
    protected array $sortTypes = [
        Integrations::SORT_BY_PLACE,
    ];

    private array $weaponsNames = [
        '',
        'P-228',
        '',
        'Scout',
        'HE Grenade',
        'XM1014',
        '',
        'MAC-10',
        'Aug',
        '',
        'Elite',
        'Five-SeveN',
        'UMP45',
        'SG-550',
        'Galil',
        'Famas',
        'USP',
        'Glock18',
        'Arctic Warfare Magnum (Police)',
        'MP5-Navy',
        'M249',
        'Benelli M3 Super 90 Combat',
        'M4A1',
        'Steyr Tactical Machine Pistol',
        'G3SG1',
        '',
        'Deagle',
        'SG-552',
        'AK-47',
        'Knife',
        'FN P90',
    ];

    private array $weaponsImages = [
        '',
        '../files/weapons/p228.png',
        '',
        '../files/weapons/scout.png',
        '../files/weapons/grenade.png',
        '../files/weapons/xm1014.png',
        '',
        '../files/weapons/mac10.png',
        '../files/weapons/aug.png',
        '',
        '../files/weapons/elite.png',
        '../files/weapons/fiveseven.png',
        '../files/weapons/ump45.png',
        '../files/weapons/sg550.png',
        '../files/weapons/galil.png',
        '../files/weapons/famas.png',
        '../files/weapons/usp.png',
        '../files/weapons/glock18.png',
        '../files/weapons/awp.png',
        '../files/weapons/mp5navy.png',
        '../files/weapons/m249.png',
        '../files/weapons/m3.png',
        '../files/weapons/m4a1.png',
        '../files/weapons/tmp.png',
        '../files/weapons/g3sg1.png',
        '',
        '../files/weapons/deagle.png',
        '../files/weapons/sg552.png',
        '../files/weapons/ak47.png',
        '../files/weapons/knife.png',
        '../files/weapons/p90.png',
    ];

    public function isValidStatisticsSortType(int $type): bool
    {
        return in_array($type, $this->sortTypes);
    }

    public function isValidDataBase(\PDO $connection, string $table = ''): bool
    {
        if (!check_table('csstats_extra_stats', $connection)) {
            return false;
        }

        return true;
    }

    public function isHasRank(Server $server, \PDO $connection): bool
    {
        return $connection
            ->query("SELECT value FROM csstats_settings WHERE command = 'army_enable' LIMIT 1")
            ->fetchColumn();
    }

    public function renderCommonStatistics(
        Server $server,
        \PDO $connection,
        \Template $tpl,
        string $name,
        int $start,
        int $limit
    ): string {
        $tpl->result['local_content'] = '';

        $isHasRank = $this->isHasRank($server, $connection);

        $STH = $connection->query('SELECT * FROM csstats_settings');
        while ($row = $STH->fetchObject()) {
            if ('statsx_skill' == $row->command) {
                $skills = explode(' ', $row->value);
            } elseif ('statsx_skillname' == $row->command) {
                $skills_names = explode(' ', $row->value);
            }
        }

        $STH = $connection->prepare('SELECT * FROM csstats_settings WHERE command LIKE :name');
        $STH->execute([':name' => '%level_name_%']);
        while ($row = $STH->fetchObject()) {
            $i = str_replace('level_name_', '', $row->command);
            $ranks[$i] = $row->value;
        }

        if (empty($skills[1])) {
            $skills = $this->defaultSkills;
        }

        if (empty($skills_names[1])) {
            $skills_names = $this->defaultSkillNames;
        }

        if (empty($ranks)) {
            $ranks = $this->defaultRanks;
        }

        $sort = $this->getSort($server->st_sort_type);

        if (empty($name)) {
            $STH = $connection->query(
                "SELECT 
					*,
				    csstats_players.id AS csid
				FROM csstats_players
				LEFT JOIN csstats_extra_stats USING (authid)
				WHERE {$this->whereStatement}
				ORDER BY {$sort}
				LIMIT {$start}, {$limit}"
            );
        } else {
            $STH = $connection->prepare(
                prepareSearchQuery(
                    "SELECT 
						*,
					    csstats_players.id AS csid
					FROM csstats_players
					LEFT JOIN csstats_extra_stats USING (authid)
					WHERE {$this->whereStatement}
						AND (nick LIKE :name OR authid LIKE :name OR ip LIKE :name)
					ORDER BY {$sort}"
                )
            );
            $STH->execute([':name' => getNameLike($name)]);
        }

        while ($row = $STH->fetchObject()) {
            ++$start;

            if (empty($row->authid)) {
                $row->authid = '';
            }

            if (empty($name)) {
                $row->place = $start;
            } else {
                $where = $this->getWhere(
                    $server->st_sort_type,
                    $row->frags,
                    $row->deaths,
                    $row->teamkills,
                    $row->headshots,
                    $row->skill,
                    $row->gametime,
                    $row->suicide,
                    $row->defused,
                    $row->explode,
                    $row->place,
                );

                $STH2 = $connection->query(
                    "SELECT 
						count(*)
					FROM csstats_players
					WHERE {$this->whereStatement}
						AND ({$where})
					ORDER BY {$sort}"
                );
                $row->place = $STH2->fetchColumn() + 1;
            }

            if ($user_profile = $this->getData->get_gamer_profile($row->nick, $row->authid)) {
                $nick = $user_profile;
            } else {
                $nick = clean($row->nick, null);
            }

            $name_history = '';
            $nick_count = 0;
            if (check_table('csstats_name_history', $connection)) {
                $STH3 = $connection->prepare('SELECT * FROM csstats_name_history WHERE authid = :auth');
                $STH3->execute([':auth' => $row->authid]);

                $name_history = 'История ников:';
                while ($names = $STH3->fetchObject()) {
                    $name_history .= '&#013;'.$names->name.' | '.expand_seconds2($names->totalplayed);
                    ++$nick_count;
                }
            }

            $j = 0;
            do {
                $skill_name = $skills_names[$j];
                $skill_color = $this->skillsColors[$j];
                ++$j;
            } while (
                isset($skills[$j])
                && ($row->skill >= $skills[$j])
                && isset($skills_names[$j], $this->skillsColors[$j])
            );

            $tpl->load_template('elements/stat.tpl');
            $tpl->set('{nick_count}', $nick_count > 0 ? '(и еще '.$nick_count.')' : '');
            $tpl->set('{name_history}', $name_history);
            $tpl->set('{hostages}', $row->hostages);
            $tpl->set('{assist}', $row->assist);
            $tpl->set('{isHasRank}', $isHasRank);
            $tpl->set('{rank}', $isHasRank ? $ranks[$row->cms_level] : '');
            $tpl->set('{level}', $row->cms_xp + $row->cms_addxp);
            $tpl->set('{level_rank}', $row->cms_level);
            $tpl->set('{level_rank_total}', count($ranks));
            $tpl->set('{suicide}', $row->suicide);
            $tpl->set('{skill_name}', $skill_name);
            $tpl->set('{skill_color}', $skill_color);
            $tpl->set('{skill}', round($row->skill));
            $tpl->set('{kill_streak}', $row->kill_streak);
            $tpl->set('{death_streak}', $row->death_streak);
            $tpl->set('{damage}', $row->damage);
            $tpl->set('{defusing}', $row->defusing);
            $tpl->set('{connects}', $row->connects);
            $tpl->set('{authid}', isNeedHidePlayerId() ? hidePlayerId($row->authid) : $row->authid);
            $tpl->set('{authid_original}', $row->authid);
            $tpl->set('{defused}', $row->defused);
            $tpl->set('{planted}', $row->planted);
            $tpl->set('{explode}', $row->explode);
            $tpl->set('{rounds}', $row->rounds);
            $tpl->set('{wint}', $row->wint);
            $tpl->set('{winct}', $row->winct);
            $tpl->set('{teamkills}', $row->teamkills);
            $tpl->set('{time}', $row->gametime ? expand_seconds2($row->gametime) : '');
            $tpl->set('{type}', $server->st_type);
            $tpl->set('{id}', $row->csid);
            $tpl->set('{place}', $row->place);
            $tpl->set('{nick}', $nick);
            $tpl->set('{frags}', $row->frags);
            $tpl->set('{deaths}', $row->deaths);
            $tpl->set('{headshots}', $row->headshots);
            $tpl->set('{shots}', $row->shots);
            $tpl->set('{hits}', $row->hits);
            $tpl->set('{kdr}', (0 == $row->deaths) ? $row->frags : round($row->frags / $row->deaths, 2));
            $tpl->set('{procent2}', get_procent($row->frags / 100, $row->headshots));
            $tpl->set('{procent3}', get_procent($row->frags / 100, $row->teamkills));
            $tpl->set('{procent4}', get_procent($row->shots / 100, $row->hits));
            $tpl->set('{date}', expand_date(date('d.m.Y H:i', $row->lasttime), 7));
            $tpl->set('{server}', $server->id);
            $tpl->compile('local_content');
            $tpl->clear();
        }

        if (empty($tpl->result['local_content'])) {
            return tableRowError('Нет результатов');
        }

        return $tpl->result['local_content'];
    }

    public function renderWeaponsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string
    {
        $tpl->result['local_content'] = '';

        $STH = $connection->prepare(
            'SELECT weapon_ak47.* FROM weapon_ak47 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_aug.* FROM weapon_aug LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_awp.* FROM weapon_awp LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_deagle.* FROM weapon_deagle LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_elite.* FROM weapon_elite LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_famas.* FROM weapon_famas LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_fiveseven.* FROM weapon_fiveseven LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_g3sg1.* FROM weapon_g3sg1 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_galil.* FROM weapon_galil LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_glock18.* FROM weapon_glock18 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_hegrenade.* FROM weapon_hegrenade LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_knife.* FROM weapon_knife LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_m3.* FROM weapon_m3 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_m4a1.* FROM weapon_m4a1 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_m249.* FROM weapon_m249 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_mac10.* FROM weapon_mac10 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_mp5navy.* FROM weapon_mp5navy LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_p90.* FROM weapon_p90 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_p228.* FROM weapon_p228 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_scout.* FROM weapon_scout LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_sg550.* FROM weapon_sg550 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_sg552.* FROM weapon_sg552 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_tmp.* FROM weapon_tmp LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_ump45.* FROM weapon_ump45 LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_usp.* FROM weapon_usp LEFT JOIN csstats_players USING (authid) WHERE id = :id UNION
			SELECT weapon_xm1014.* FROM weapon_xm1014 LEFT JOIN csstats_players USING (authid) WHERE id = :id'
        );
        $STH->execute([':id' => $playerId]);
        while ($row = $STH->fetchObject()) {
            if (!$row->shots and !$row->damage) {
                continue;
            }

            $tpl->load_template('elements/stat_weapon.tpl');
            $tpl->set('{weapon_image}', $this->weaponsImages[$row->weapon_id]);
            $tpl->set('{weapon_name}', $this->weaponsNames[$row->weapon_id]);
            $tpl->set('{wkills}', $row->frags);
            $tpl->set('{wshots}', $row->shots);
            $tpl->set('{whits}', $row->hits);
            $tpl->set('{wdamage}', $row->damage);
            $tpl->set('{whit_generic}', $row->hit_generic);
            $tpl->set('{whit_head}', $row->hit_head);
            $tpl->set('{whit_chest}', $row->hit_chest);
            $tpl->set('{whit_stomach}', $row->hit_stomach);
            $tpl->set('{whit_leftarm}', $row->hit_leftarm);
            $tpl->set('{whit_rightarm}', $row->hit_rightarm);
            $tpl->set('{whit_leftleg}', $row->hit_leftleg);
            $tpl->set('{whit_rightleg}', $row->hit_rightleg);
            $tpl->compile('local_content');
            $tpl->clear();
        }

        if ('' == $tpl->result['local_content']) {
            global $messages;

            return tableRowError($messages['informationNotFound']);
        }

        return $tpl->result['local_content'];
    }

    public function renderMapsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string
    {
        $tpl->result['local_content'] = '';

        $STH = $connection->prepare(
            'SELECT csstats_maps.* FROM csstats_maps LEFT JOIN csstats_players USING (authid) WHERE id = :id'
        );
        $STH->execute([':id' => $playerId]);
        while ($row = $STH->fetchObject()) {
            $tpl->load_template('elements/stat_map.tpl');
            $tpl->set('{mapname}', $row->mapname);
            $tpl->set('{mfrags}', $row->frags);
            $tpl->set('{mdeaths}', $row->deaths);
            $tpl->set('{mheadshots}', $row->headshots);
            $tpl->set('{mgametime}', expand_seconds2($row->gametime));
            $tpl->set('{mrounds}', $row->rounds);
            $tpl->compile('local_content');
            $tpl->clear();
        }

        if ('' == $tpl->result['local_content']) {
            global $messages;

            return tableRowError($messages['informationNotFound']);
        }

        return $tpl->result['local_content'];
    }

    protected function getSort($type): string
    {
        $sort = '';

        if (Integrations::SORT_BY_PLACE == $type) {
            $sort = 'place';
        }

        return $sort;
    }

    protected function getWhere(
        $type,
        $frags = null,
        $deaths = null,
        $teamkills = null,
        $headshots = null,
        $skill = null,
        $gametime = null,
        $suicide = null,
        $defused = null,
        $explode = null,
        $place = null
    ): string {
        $where = '';

        if (Integrations::SORT_BY_PLACE == $type) {
            $where = 'place < '.$place;
        }

        return $where;
    }
}
