<?php

namespace GameCMS\Statistics;

use GameCMS\Models\Server;

class BlankIntegration implements StatisticIntegration
{
    public function getStorageConnection(Server $server): array
    {
        return [null, null];
    }

    public function isBlank(): bool
    {
        return true;
    }

    public function isValidStatisticsSortType(int $type): bool
    {
        return true;
    }

    public function isValidDataBase(\PDO $connection, string $table = ''): bool
    {
        return true;
    }

    public function removeStats(Server $server, \PDO $connection, string $playerId): bool
    {
        return true;
    }

    public function getStatsCount(Server $server, \PDO $connection): int
    {
        return 0;
    }

    public function isHasRank(Server $server, \PDO $connection): bool
    {
        return false;
    }

    public function renderCommonStatistics(
        Server $server,
        \PDO $connection,
        \Template $tpl,
        string $name,
        int $start,
        int $limit
    ): string {
        return '';
    }

    public function renderWeaponsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string
    {
        return '';
    }

    public function renderMapsStatistics(Server $server, \PDO $connection, \Template $tpl, string $playerId): string
    {
        return '';
    }
}
