<?php

namespace GameCMS\Statistics;

use GameCMS\Models\Server;

class ArmyRanksUltimateIntegration extends CsStatsMysqlIntegration implements StatisticIntegration
{
    protected array $defaultRanks = [
        'Курсант',
        'Рядовой',
        'Ефрейтор',
        'Мл.сержант',
        'Сержант',
        'Ст.сержант',
        'Старшина',
        'Прапорщик',
        'Ст.прапорщик',
        'Мл.лейтенант',
        'Лейтенант',
        'Ст.лейтенант',
        'Капитан',
        'Майор',
        'Подполковник',
        'Полковник',
        'Генерал - Майор',
        'Генерал - Лейтенант',
        'Генерал - Полковник',
        'Генерал - Армии',
        'Маршал РФ',
    ];

    public function isValidDataBase(\PDO $connection, string $table = ''): bool
    {
        if (!parent::isValidDataBase($connection)) {
            return false;
        }

        $value = $connection
            ->query("SELECT value FROM csstats_settings WHERE command = 'army_enable' LIMIT 1")
            ->fetchColumn();

        if (!$value) {
            return false;
        }

        return true;
    }

    public function isHasRank(Server $server, \PDO $connection): bool
    {
        return true;
    }

    public function renderCommonStatistics(
        Server $server,
        \PDO $connection,
        \Template $tpl,
        string $name,
        int $start,
        int $limit
    ): string {
        $tpl->result['local_content'] = '';

        $isHasRank = $this->isHasRank($server, $connection);

        $STH = $connection->query('SELECT * FROM csstats_settings');
        while ($row = $STH->fetchObject()) {
            if ('ar_levels' == $row->command) {
                $levels = explode(' ', $row->value);
            } elseif ('ar_xp_value' == $row->command) {
                $cv_XPvalue = $row->value;
            } elseif ('ar_xp_c4def' == $row->command) {
                $cv_XPc4def = $row->value;
            } elseif ('statsx_skill' == $row->command) {
                $skills = explode(' ', $row->value);
            } elseif ('statsx_skillname' == $row->command) {
                $skills_names = explode(' ', $row->value);
            } elseif ('ar_bonus_he' == $row->command) {
                $ar_bonus_hes = explode(' ', $row->value);
            } elseif ('ar_bonus_flash' == $row->command) {
                $ar_bonus_flashs = explode(' ', $row->value);
            } elseif ('ar_bonus_smoke' == $row->command) {
                $ar_bonus_smokes = explode(' ', $row->value);
            } elseif ('ar_bonus_defuse' == $row->command) {
                $ar_bonus_defuses = explode(' ', $row->value);
            } elseif ('ar_bonus_nv' == $row->command) {
                $ar_bonus_nvs = explode(' ', $row->value);
            } elseif ('ar_bonus_armor' == $row->command) {
                $ar_bonus_armors = explode(' ', $row->value);
            } elseif ('ar_bonus_hp' == $row->command) {
                $ar_bonus_hps = explode(' ', $row->value);
            } elseif ('ar_bonus_flags' == $row->command) {
                $ar_bonus_flagss = explode(' ', $row->value);
            } elseif ('ar_bonus_damage' == $row->command) {
                $ar_bonus_damages = explode(' ', $row->value);
            }
        }

        $STH = $connection->prepare('SELECT * FROM csstats_settings WHERE command LIKE :name');
        $STH->execute([':name' => '%level_name_%']);
        while ($row = $STH->fetchObject()) {
            $i = str_replace('level_name_', '', $row->command) - 1;
            $ranks[$i] = $row->value;
        }

        if (empty($cv_XPvalue)) {
            $cv_XPvalue = 0;
        }

        if (empty($cv_XPc4def)) {
            $cv_XPc4def = 0;
        }

        if (empty($levels[1])) {
            $levels = [];
        }

        $levelsCount = count($levels);

        if (empty($skills[1])) {
            $skills = $this->defaultSkills;
        }

        if (empty($skills_names[1])) {
            $skills_names = $this->defaultSkillNames;
        }

        if (empty($ar_bonus_hes) || count($ar_bonus_hes) < $levelsCount) {
            $ar_bonus_hes = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_flashs) || count($ar_bonus_flashs) < $levelsCount) {
            $ar_bonus_flashs = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_smokes) || count($ar_bonus_smokes) < $levelsCount) {
            $ar_bonus_smokes = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_defuses) || count($ar_bonus_defuses) < $levelsCount) {
            $ar_bonus_defuses = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_nvs) || count($ar_bonus_nvs) < $levelsCount) {
            $ar_bonus_nvs = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_armors) || count($ar_bonus_armors) < $levelsCount) {
            $ar_bonus_armors = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_hps) || count($ar_bonus_hps) < $levelsCount) {
            $ar_bonus_hps = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_flagss) || count($ar_bonus_flagss) < $levelsCount) {
            $ar_bonus_flagss = array_fill(0, $levelsCount, 0);
        }

        if (empty($ar_bonus_damages) || count($ar_bonus_damages) < $levelsCount) {
            $ar_bonus_damages = array_fill(0, $levelsCount, 0);
        }

        if (empty($ranks[1])) {
            $ranks = $this->defaultRanks;
        }

        $sort = $this->getSort($server->st_sort_type);

        if (empty($name)) {
            $STH = $connection->query(
                "SELECT *
				FROM csstats_players
				WHERE {$this->whereStatement}
				ORDER BY {$sort}
				LIMIT {$start}, {$limit}"
            );
        } else {
            $STH = $connection->prepare(
                prepareSearchQuery(
                    "SELECT *
					FROM csstats_players
					WHERE {$this->whereStatement}
						AND (nick LIKE :name OR authid LIKE :name OR ip LIKE :name)
					ORDER BY {$sort}"
                )
            );
            $STH->execute([':name' => getNameLike($name)]);
        }

        while ($row = $STH->fetchObject()) {
            ++$start;

            if (empty($row->authid)) {
                $row->authid = '';
            }

            if (empty($name)) {
                $row->place = $start;
            } else {
                $where = $this->getWhere(
                    $server->st_sort_type,
                    $row->frags,
                    $row->deaths,
                    $row->teamkills,
                    $row->headshots,
                    $row->skill,
                    $row->gametime,
                    $row->suicide,
                    $row->defused,
                    $row->explode,
                    $row->place
                );

                $STH2 = $connection->query(
                    "SELECT 
						count(*)
					FROM csstats_players
					WHERE {$this->whereStatement}
						AND ({$where})
					ORDER BY {$sort}"
                );
                $row->place = $STH2->fetchColumn() + 1;
            }

            $j = 0;
            $level = ($row->headshots + $row->frags + $row->defused * $cv_XPc4def + $row->explode * $cv_XPc4def) * $cv_XPvalue;
            do {
                $rank = $ranks[$j];
                $ar_bonus_he = $ar_bonus_hes[$j];
                $ar_bonus_flash = $ar_bonus_flashs[$j];
                $ar_bonus_smoke = $ar_bonus_smokes[$j];
                $ar_bonus_defuse = $ar_bonus_defuses[$j];
                $ar_bonus_nv = $ar_bonus_nvs[$j];
                $ar_bonus_armor = $ar_bonus_armors[$j];
                $ar_bonus_hp = $ar_bonus_hps[$j];
                $ar_bonus_flags = $ar_bonus_flagss[$j];
                $ar_bonus_damage = $ar_bonus_damages[$j];
                ++$j;
            } while (
                isset($levels[$j])
                && ($level >= $levels[$j])
                && isset(
                    $ranks[$j],
                    $ar_bonus_hes[$j],
                    $ar_bonus_flashs[$j],
                    $ar_bonus_smokes[$j],
                    $ar_bonus_defuses[$j],
                    $ar_bonus_nvs[$j],
                    $ar_bonus_armors[$j],
                    $ar_bonus_hps[$j],
                    $ar_bonus_flagss[$j],
                    $ar_bonus_damages[$j]
                )
            );

            if ($user_profile = $this->getData->get_gamer_profile($row->nick, $row->authid)) {
                $nick = $user_profile;
            } else {
                $nick = clean($row->nick, null);
            }

            $j = 0;
            do {
                $skill_name = $skills_names[$j];
                $skill_color = $this->skillsColors[$j];
                ++$j;
            } while (isset($skills[$j]) && ($row->skill >= $skills[$j]) && isset($skills_names[$j], $this->skillsColors[$j]));

            $tpl->load_template('elements/stat.tpl');
            $tpl->set('{ar_bonus_he}', $ar_bonus_he);
            $tpl->set('{ar_bonus_flash}', $ar_bonus_flash);
            $tpl->set('{ar_bonus_smoke}', $ar_bonus_smoke);
            $tpl->set('{ar_bonus_defuse}', $ar_bonus_defuse);
            $tpl->set('{ar_bonus_nv}', $ar_bonus_nv);
            $tpl->set('{ar_bonus_hp}', $ar_bonus_hp);
            $tpl->set('{ar_bonus_armor}', $ar_bonus_armor);
            $tpl->set('{ar_bonus_flags}', $ar_bonus_flags);
            $tpl->set('{ar_bonus_damage}', $ar_bonus_damage);
            $tpl->set('{suicide}', $row->suicide);
            $tpl->set('{rank}', $rank);
            $tpl->set('{level}', $level);
            $tpl->set('{skill_name}', $skill_name);
            $tpl->set('{skill_color}', $skill_color);
            $tpl->set('{skill}', round($row->skill));
            $tpl->set('{damage}', $row->damage);
            $tpl->set('{defusing}', $row->defusing);
            $tpl->set('{connects}', $row->connects);
            $tpl->set('{authid}', isNeedHidePlayerId() ? hidePlayerId($row->authid) : $row->authid);
            $tpl->set('{authid_original}', $row->authid);
            $tpl->set('{defused}', $row->defused);
            $tpl->set('{planted}', $row->planted);
            $tpl->set('{explode}', $row->explode);
            $tpl->set('{rounds}', $row->rounds);
            $tpl->set('{wint}', $row->wint);
            $tpl->set('{winct}', $row->winct);
            $tpl->set('{teamkills}', $row->teamkills);
            $tpl->set('{time}', $row->gametime ? expand_seconds2($row->gametime) : '');
            $tpl->set('{type}', $server->st_type);
            $tpl->set('{isHasRank}', $isHasRank);
            $tpl->set('{id}', $row->id);
            $tpl->set('{place}', $row->place);
            $tpl->set('{nick}', $nick);
            $tpl->set('{frags}', $row->frags);
            $tpl->set('{deaths}', $row->deaths);
            $tpl->set('{headshots}', $row->headshots);
            $tpl->set('{shots}', $row->shots);
            $tpl->set('{hits}', $row->hits);
            $tpl->set('{kdr}', (0 == $row->deaths) ? $row->frags : round($row->frags / $row->deaths, 2));
            $tpl->set('{procent2}', get_procent($row->frags / 100, $row->headshots));
            $tpl->set('{procent3}', get_procent($row->frags / 100, $row->teamkills));
            $tpl->set('{procent4}', get_procent($row->shots / 100, $row->hits));
            $tpl->set('{date}', expand_date(date('d.m.Y H:i', $row->lasttime), 7));
            $tpl->set('{server}', $server->id);
            $tpl->compile('local_content');
            $tpl->clear();
        }

        if (empty($tpl->result['local_content'])) {
            return tableRowError('Нет результатов');
        }

        return $tpl->result['local_content'];
    }
}
