<?php

namespace GameCMS\Services\HeadApi;

use GameCMS\Clients\Curl;
use GameCMS\Common\Error;

class TemplatesService
{
    private Curl $client;

    public function __construct(Curl $client)
    {
        $this->client = $client;
    }

    /**
     * @return array{?string, ?string, ?Error}
     */
    public function getInstaller(string $license, float $version, string $key, ?string $storeKey = null): array
    {
        $response = $this->client->post('/api-engine.php', [
            'action' => 'get_good',
            'good_type' => '2',
            'license' => $license,
            'version' => $version,
            'key' => $key,
            'store_key' => $storeKey,
        ]);

        $template_name = $this->client->getResponseHeaders()['Good-Name'];

        if ($this->client->isHttpError() || empty($template_name)) {
            $response = json_decode($response, true);

            if (isset($response['error'])) {
                $error = $response['error']['title'].': '.$response['error']['detail'];
            } else {
                $error = 'Произошла ошибка';
            }

            return [null, null, error($error)];
        }

        return [$response, $template_name, null];
    }
}
