<?php

namespace GameCMS\Services\HeadApi;

use GameCMS\Clients\Curl;
use GameCMS\Common\Error;

class StoresService
{
    private Curl $client;

    public function __construct(Curl $client)
    {
        $this->client = $client;
    }

    /**
     * @return array{?array{key: string, name: string}, ?Error}
     */
    public function enableStores(array $names, string $license): array
    {
        $response = $this->client->post('/api-engine.php', [
            'action' => 'enable_stores',
            'license' => $license,
            'names' => json_encode($names),
        ]);

        $response = json_decode($response, true);

        if ($this->client->isHttpError() || empty($response['data'])) {
            if (isset($response['error'])) {
                $error = $response['error']['title'].': '.$response['error']['detail'];
            } else {
                $error = 'Произошла ошибка';
            }

            return [null, error($error)];
        }

        return [$response['data'], null];
    }
}
