<?php

namespace GameCMS\Integrations\Admins;

use GameCMS\Models\Admin;
use GameCMS\Models\Server;

class GameCMSIntegration implements AdminSystemIntegration
{
    use AdminSystemHelpers;

    public function isBlank(): bool
    {
        return false;
    }

    public function removeAdmin(string $adminFindName, $connection, Server $server): array
    {
        return [true, null];
    }

    public function exportAdmin(string $adminFindName, $connection, Server $server, Admin $admin): array
    {
        return [true, null];
    }

    public function importAdmins($connection, Server $server): array
    {
        return [true, null];
    }

    public function isImmunityUsing(): bool
    {
        return false;
    }

    public function isGroupsUsing(): bool
    {
        return false;
    }

    public function getStorageConnection(Server $server): array
    {
        return [pdo(), null];
    }

    public function exportAdmins($connection, Server $server, array $admins): array
    {
        return [true, null];
    }

    public function isNickWithPasswordAuthAllowed(): bool
    {
        return true;
    }

    public function isSteamIdAuthAllowed(): bool
    {
        return true;
    }

    public function isSteamIdWithPasswordAuthAllowed(): bool
    {
        return true;
    }
}
