<?php

include_once __DIR__.'/../inc/start.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken() || !is_auth()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

if (isset($_POST['dell_chat_message']) and is_worthy('d')) {
    $id = check($_POST['id'], 'int');
    $pdo->exec("DELETE FROM `chat` WHERE `id`='{$id}' LIMIT 1");
}
if (isset($_POST['save_chat_message']) and is_worthy('d')) {
    $id = check($_POST['id'], 'int');
    if (empty($_POST['text'])) {
        exit;
    }

    $text = clean_from_php($_POST['text']);
    $text = magic_quotes($text);
    $text = htmlspecialchars_decode($text);
    $text = GetHTMLPurifier()->purify($text);

    $STH = $pdo->prepare('UPDATE `chat` SET `message_text`=:message_text WHERE `id`=:id LIMIT 1');
    if ('1' == $STH->execute([':message_text' => $text, ':id' => $id])) {
        exit(json_encode(['status' => '1', 'text' => $text]));
    }

    exit;
}
if (isset($_POST['add_new_img']) and is_worthy('b')) {
    if (empty($_FILES['new_img']['name'])) {
        exit('<script>show_input_error("new_img", "", null);setTimeout(show_error, 500);</script>');
    }
    $path = 'files/news_imgs/';
    $date = time();

    if (if_img($_FILES['new_img']['name'])) {
        $filename = $_FILES['new_img']['name'];
        $source = $_FILES['new_img']['tmp_name'];
        $new_img = $path.$date.'.jpg';
        $target = '../'.$new_img;
        move_uploaded_file($source, $target);
    } else {
        exit('<p class="text-danger">Изображение должено быть в формате JPG,GIF или PNG</p><script>show_input_error("new_img", "", null);setTimeout(show_error, 500);</script>');
    }
    echo '
		<script>$("#img").attr("src","../'.$new_img.'");setTimeout(show_ok, 500);</script>
		<input value="'.$new_img.'" type="hidden" id="input_img" maxlength="255" autocomplete="off">
		';

    exit;
}
if (isset($_POST['add_new']) and is_worthy('b')) {
    $img = check($_POST['img'], null);
    $class = check($_POST['class'], 'int');
    $name = check($_POST['name'], null);
    $short_text = check($_POST['short_text'], null);
    $date = check($_POST['date'], null);
    $date = date('Y-m-d H:i:s', strtotime($date));

    $text = GetHTMLPurifier()->purify($_POST['text']);
    $text = find_img_mp3($text, $_SESSION['id'], 1);

    if (empty($img)) {
        $img = 'files/news_imgs/none.jpg';
    }

    if (empty($class)) {
        $result = ['status' => '2', 'input' => 'class', 'reply' => ''];

        exit(json_encode($result));
    }
    if (empty($name)) {
        $result = ['status' => '2', 'input' => 'name', 'reply' => 'Заполните!'];

        exit(json_encode($result));
    }
    if (empty($short_text)) {
        $result = ['status' => '2', 'input' => 'short_text', 'reply' => 'Заполните!'];

        exit(json_encode($result));
    }
    if (empty($text)) {
        $result = ['status' => '2', 'input' => 'text', 'reply' => 'Заполните!'];

        exit(json_encode($result));
    }

    if (mb_strlen($name, 'UTF-8') > 250) {
        $result = ['status' => '2', 'input' => 'name', 'reply' => 'Не более 250 символов!'];

        exit(json_encode($result));
    }
    if (mb_strlen($short_text, 'UTF-8') > 250) {
        $result = ['status' => '2', 'input' => 'short_text', 'reply' => 'Не более 250 символов!'];

        exit(json_encode($result));
    }

    $STH = $pdo->prepare('INSERT INTO news (img,class,new_name,short_text,text,date,author,views) values (:img, :class, :name, :short_text, :text, :date, :author, :views)');
    if ('1' == $STH->execute(['img' => $img, 'class' => $class, 'name' => $name, 'short_text' => $short_text, 'text' => $text, 'date' => $date, 'author' => $_SESSION['id'], 'views' => '1'])) {
        $id = get_ai($pdo, 'news');
        --$id;

        if (strtotime($date) <= time()) {
            $ES = new EventsRibbon($pdo);
            $ES->new_new($id, $name);
        }

        write_sitemap($full_site_host.'news/new?id='.$id);

        exit(json_encode(['status' => '1', 'id' => $id]));
    }
}
if (isset($_POST['change_new']) and is_worthy('q')) {
    $id = check($_POST['id'], 'int');
    $img = check($_POST['img'], null);
    $class = check($_POST['class'], 'int');
    $name = check($_POST['name'], null);
    $short_text = check($_POST['short_text'], null);
    $date = check($_POST['date'], null);
    $date = date('Y-m-d H:i:s', strtotime($date));

    $text = GetHTMLPurifier()->purify($_POST['text']);
    $text = find_img_mp3($text, $id, 1);

    if (empty($img)) {
        $img = 'files/news_imgs/none.jpg';
    }

    if (empty($class)) {
        exit(json_encode(['status' => '2', 'input' => 'class', 'reply' => '']));
    }
    if (empty($name)) {
        exit(json_encode(['status' => '2', 'input' => 'name', 'reply' => 'Заполните!']));
    }
    if (empty($short_text)) {
        exit(json_encode(['status' => '2', 'input' => 'short_text', 'reply' => 'Заполните!']));
    }
    if (empty($text)) {
        exit(json_encode(['status' => '2', 'input' => 'text', 'reply' => 'Заполните!']));
    }

    if (mb_strlen($name, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'name', 'reply' => 'Не более 250 символов!']));
    }
    if (mb_strlen($short_text, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'short_text', 'reply' => 'Не более 250 символов!']));
    }

    $STH = $pdo->prepare("UPDATE news SET img=:img,class=:class,new_name=:name,short_text=:short_text,text=:text,date=:date WHERE id='{$id}' LIMIT 1");
    if ('1' == $STH->execute(['img' => $img, 'class' => $class, 'name' => $name, 'short_text' => $short_text, 'text' => $text, 'date' => $date])) {
        exit(json_encode(['status' => '1', 'id' => $id]));
    }
}
if (isset($_POST['dell_new_comment']) and is_worthy('q')) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = $pdo->prepare("DELETE FROM `events` WHERE `data_id`=:data_id AND `type` = '2' LIMIT 1");
    $STH->execute([':data_id' => $id]);

    $pdo->exec("DELETE FROM `news__comments` WHERE `id`='{$id}' LIMIT 1");

    exit;
}
if (isset($_POST['edit_topic'])) {
    $img = check($_POST['img'], null);
    $id = check($_POST['id'], 'int');
    $name = check($_POST['name'], null);

    $text = GetHTMLPurifier()->purify($_POST['text']);
    $text = find_img_mp3($text, $id, 1);

    if (empty($img)) {
        $img = 'files/forums_imgs/none.jpg';
    }
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }
    if (empty($name)) {
        exit(json_encode(['status' => '2', 'input' => 'name', 'reply' => 'Заполните!']));
    }
    if (empty($text)) {
        exit(json_encode(['status' => '2', 'input' => 'text', 'reply' => 'Заполните!']));
    }
    if (mb_strlen($name, 'UTF-8') > 250) {
        exit(json_encode(['status' => '2', 'input' => 'name', 'reply' => 'Не более 250 символов!']));
    }

    $Forum = new Forum($pdo);
    if ($Forum->edit_topic($id, $name, $text, $img)) {
        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['edit_message'])) {
    $id = check($_POST['id'], 'int');

    $text = GetHTMLPurifier()->purify($_POST['text']);
    $text = find_img_mp3($text, $id, 1);

    if (empty($text)) {
        exit(json_encode(['status' => '3', 'input' => 'text', 'reply' => 'Заполните!']));
    }

    $Forum = new Forum($pdo);
    if ($Forum->edit_answer($id, $text)) {
        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['load_forums_list'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    $Forum->get_forums_list($id);

    exit;
}
if (isset($_POST['edit_topic_forum']) and is_worthy('e')) {
    $id = check($_POST['id'], 'int');
    $forum = check($_POST['forum'], 'int');

    if (empty($id) or empty($forum)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    if ($Forum->edit_topic_forum($id, $forum)) {
        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['edit_topic_status']) and is_worthy('e')) {
    $id = check($_POST['id'], 'int');
    $status = check($_POST['status'], 'int');

    if (empty($id) or empty($status)) {
        exit(json_encode(['status' => '2']));
    }
    if (1 != $status and 2 != $status and 3 != $status and 4 != $status) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    if ($Forum->edit_topic_status($id, $status)) {
        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['dell_answer']) and is_worthy('r')) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $Forum = new Forum($pdo);
    if ($Forum->dell_answer($id, 1)) {
        write_log('Удален ответ форума ID:'.$id);

        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['dell_ban_comment']) and is_worthy('o')) {
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = $pdo->prepare('SELECT `bans`.`server` FROM `bans__comments` 
		LEFT JOIN `bans` ON `bans__comments`.`ban_id` = `bans`.`id` 
		WHERE `bans__comments`.`id` = :id LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);
    $row = $STH->fetch();

    if (!is_worthy_specifically('o', $row->server)) {
        exit(json_encode(['status' => '2']));
    }

    $pdo->exec("DELETE FROM `bans__comments` WHERE `id`='{$id}' LIMIT 1");

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['dell_event']) and is_worthy('d')) {
    $id = check($_POST['id'], 'int');

    $pdo->exec("DELETE FROM `events` WHERE `id`='{$id}' LIMIT 1");

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['removeComplaintComment']) && is_worthy('u')) {
    $id = check($_POST['id'], 'int');

    if (empty($id)) {
        exit(json_encode(['status' => 2]));
    }

    $STH = $pdo->prepare(
        'SELECT 
				    complaints.accused_admin_server_id 
				FROM complaints__comments 
				    LEFT JOIN complaints ON complaints__comments.complaint_id = complaints.id 
				WHERE complaints__comments.id = :id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);
    $row = $STH->fetch();

    if (!is_worthy_specifically('u', $row->accused_admin_server_id)) {
        exit(json_encode(['status' => 2]));
    }

    $STH = $pdo->prepare('DELETE FROM complaints__comments WHERE id=:id LIMIT 1');
    $STH->execute([':id' => $id]);

    exit(json_encode(['status' => 1]));
}

exit(json_encode(['status' => 2]));
