<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Запрос на проведение Упрощённой идентификации пользователя.
	 * Для прохождения упрощённой идентификации у пользователя в личном кабинете должны быть заполнены:
	 * Фамилия
	 * Имя
	 * Отчество
	 * Сотовый телефон
	 * Дата рождения (необязательно)
	 * СНИЛС (необязательно)
	 * ИНН (необязательно)
	 * Паспорт РФ (в разделе Документы)
	 * Упрощённая идентификация доступна только для граждан России. Поэтому, если в личном кабинете указана страна, то это должна быть Россия.
	 * Сотовый телефон в личном кабинете пользователя должен быть "подтвержден". Если он не подтвержден, то в ответе будет ошибка с кодом "500.7.5".
	 * Для подтверждения сотового телефона следует использовать запросы ApprovePhoneSendConfirmationRequest и ApprovePhoneApplyCodeRequest.
	 * Для прохождения упрощенной идентификации необходимо знать либо ИНН, либо СНИЛС (можно указать оба поля).
	 * Если ИНН и СНИЛС неизвестны, то можно указать Дату рождения пользователя. Используя Дату рождения пользователя, мы сможем получить ИНН пользователя,
	 * который будет использован для прохождения упрощенной идентификации.
	 * Если в личном кабинете пользователя все необходимые данные уже заполнены
	 * (например, запросами EditProfileRequest, CreateProfileDocumentRequest или EditProfileDocumentRequest), и сотовый телефон подтвержден,
	 * то в данном запросе элемент personalInformation можно не присылать.
	 * Если элемент personalInformation будет заполнен (полностью или частично), то все присланные данные будут сохранены в личном кабинете пользователя.
	 * Упрощённая идентификация происходит обычно в течение часа.
	 * Request for user simplified identification.
	 * 
 */
class SimplifiedIdentificationRequest extends AbstractAttributeObject
{
	
	/**
	 * ID пользователя в системе MONETA.RU. Если это поле не задано, то используется текущий пользователь.
	 * User ID. If you omit this element, MONETA.RU uses the ID of the user who sends the request.
	 * 
	 *
	 * @var long
	 */
	 public $unitId = null;

	/**
	 * В profile должны быть заполнены следующие поля:
	 * first_name
	 * middle_initial_name
	 * last_name
	 * cell_phone
	 * date_of_birth (optional)
	 * snils (optional)
	 * inn (optional)
	 * В document должны быть заполнены следующие поля:
	 * type (всегда равен PASSPORT)
	 * series
	 * number
	 * issuer
	 * issued
	 * department
	 * User information must contain the following attributes:
	 * first_name
	 * middle_initial_name
	 * last_name
	 * cell_phone
	 * date_of_birth (optional)
	 * snils (optional)
	 * inn (optional)
	 * The document must contain the following attributes:
	 * type (PASSPORT)
	 * series
	 * number
	 * issuer
	 * issued
	 * department
	 * 
	 *
	 * @var PersonalInformation
	 */
	 public $personalInformation = null;

}
