<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий параметры операции в запросах. Отличается от TransactionRequestType тем, что в качестве получателя можно указывать не только номер счета.
	 * Transaction parameters for requests. Unlike the TransactionRequestType element, the payee element in PaymentRequestType can specify not only the account number, but also a transaction ID, e-mail, or phone number.
	 * 
 */
class PaymentRequestType extends Entity
{
	
	/**
	 * Номер счета плательщика.
	 * The account number of the payer.
	 * 
	 *
	 * @var string
	 */
	 public $payer = null;

	/**
	 * Может принимать следующие значения:
	 * E-mail получателя. Сумма зачисляется на "основной счет" получателя, найденного по данному E-mail.
	 * Номер операции - если значение этого поля начинается с "0". То есть значение 012345678 означает оплату операции 12345678.
	 * Телефон получателя - если значение этого поля начинается со знака "+". Сумма зачисляется на "основной счет" получателя, найденного по данному телефону.
	 * Номер счета получателя
	 * The unique identifier of the payee. This element can take one of the following values:
	 * E-mail address of the payee. The funds are transferred to the primary MONETA.RU account that is registered to the specified e-mail address.
	 * Transaction ID that is prefixed with a zero. For example, to indicate that you specify a transaction ID 12345678, use 012345678.
	 * Phone number of that payee that is prefixed with the plus sign (+). The funds are transferred to the primary MONETA.RU account that is registered to the specified phone number.
	 * Account number of the payee. This number must contain only digits.
	 * 
	 *
	 * @var string
	 */
	 public $payee = null;

	/**
	 * Сумма операции.
	 * Если флаг isPayerAmount отсутствует и пользователь имеет доступ только к счету плательщика, то интерпретируется как сумма к списанию (в валюте плательщика).
	 * Если флаг isPayerAmount отсутствует и пользователь имеет доступ только к счету получателя, то интерпретируется как сумма к зачислению (в валюте получателя).
	 * Transaction amount. The currency of the transaction is specified by the isPayerAmount element. If a request does not include the isPayerAmount element, MONETA.RU uses the following rules to determine the currency of the transaction:
	 * If a user has access only to the payer's account, MONETA.RU uses the currency of the payer's account for the transaction.
	 * If a user has access only to the payee's account, MONETA.RU uses the currency of the payee's account for the transaction.
	 * 
	 *
	 * @var decimal
	 */
	 public $amount = null;

	/**
	 * Если пользователь имеет доступ как к счету плательщика, так и счету получателя, то флаг isPayerAmount обязателен.
	 * Если флаг isPayerAmount установлен (true), то amount используется как сумма к списанию (в валюте плательщика).
	 * Если флаг isPayerAmount сброшен (false), то amount используется как сумма к зачислению (в валюте получателя).
	 * This element is required if a user has access to the payer's and to the payee's accounts. Valid values:
	 * true. MONETA.RU uses the currency of the payer's account for the transaction amount.
	 * false. MONETA.RU uses the currency of the payee's account for the transaction amount.
	 * 
	 *
	 * @var boolean
	 */
	 public $isPayerAmount = null;

	/**
	 * Платежный пароль счета плательщика.
	 * Payment password for the payer's MONETA.RU account.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $paymentPassword = null;

	/**
	 * Внешний номер операции.
	 * Merchant transaction ID.
	 * 
	 *
	 * @var string
	 */
	 public $clientTransaction = null;

	/**
	 * Описание операции.
	 * Transaction description or comments.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $description = null;

	/**
	 * Набор полей, которые необходимо сохранить в качестве атрибутов операции. Значения дат в формате dd.MM.yyyy HH:mm:ss
	 * Key-value pairs that will be saved as transaction attributes. For dates, use the following format: dd.MM.yyyy HH:mm:ss
	 * 
	 *
	 * @var OperationInfo
	 */
	 public $operationInfo = null;

	/**
	 * Запрос для платежного пароля.
	 * Challenge passcode that you received in the GetAccountPaymentPasswordChallenge response in the paymentPasswordChallenge element. Specify this element in the following cases:
	 * If a user gets payment passwords by SMS, set paymentPasswordChallenge to SMS. Set paymentPassword to the value that the user receives in the SMS from MONETA.RU.
	 * If a user gets a sequence number (index) for a password from a list of transaction authentication numbers (TANs), set paymentPasswordChallenge to the TAN index. Set paymentPassword to the TAN that has the specified index.
	 * 
	 *
	 * @var string
	 */
	 public $paymentPasswordChallenge = null;

}
