<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий данные в виде бинарного файла.
	 * Binary data.
	 * 
 */
class File
{
	
	/**
	 * ID документа, которому принадлежит данный файл.
	 * Unique identifier of the document to which the file belongs.
	 * 
	 *
	 * @var long
	 */
	 public $documentId = null;

	/**
	 * Данные файла. При передаче/получении данных используйте MTOM (Message Transmission Optimization Mechanism).
	 * File contents. Use MTOM (Message Transmission Optimization Mechanism) to send and fetch the data.
	 * 
	 *
	 * @var base64Binary
	 */
	 public $blob = null;

	/**
	 * Проверен или нет данный файл.
	 * Indicates whether the file is verified or not.
	 * 
	 *
	 * @var boolean
	 */
	 public $approved = null;

	/**
	 * ID файла.
	 * File ID.
	 * 
	 *
	 * @var long
	 */
	 public $fileId = null;

	/**
	 * Mime type файла (например: image/jpeg).
	 * MIME type of the file.
	 * For example, image/jpeg for an image in jpeg format.
	 * 
	 *
	 * @var string
	 */
	 public $mimeType = null;

	/**
	 * Имя файла или описание.
	 * File name or description.
	 * 
	 *
	 * @var string
	 */
	 public $title = null;

	/**
	 * Ссылка для скачивания файла. Ссылка является относительной. Например: /info/private/documents/FILE.png.
	 * Для скачивания файла следует добавить имя сервера. Например: https://moneta.ru.
	 * Ссылка возвращается только если запрос был создан в формате JSON. Если запрос был создан в формате SOAP, то данные файла располагаются в поле blob.
	 * Файл по указанной ссылке, можно скачать, только если пользователь авторизован в системе. Это бывает не всегда удобно.
	 * Для того, чтобы скачать файл без авторизации, можно получить временную ссылку, которая будет действовать 30 минут.
	 * Временная ссылка будет создана автоматически, если у пользователя, который вызывает данный метод,
	 * в разделе "Мой счет" - "Безопасность" создан "Публичный идентификатор".
	 * В этом случае ссылка будет иметь вид: /info/private/documents/FILE.png?publicId=PUBLIC_ID&date=yyyy-MM-dd_HH-mm&signature=SIGNATURE
	 * Если время действия ссылки закончилось, то в ответ будет отдаваться HTTP status code: 400 (Bad Request).
	 * Если в ссылке для скачивания будут изменены параметры, то в ответ будет отдаваться HTTP status code: 400 (Bad Request).
	 * Direct link for binary data
	 * 
	 *
	 * @var string
	 */
	 public $requestUri = null;

}
