<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Запрос на создание счета. Счет создается для указанного пользователя или, если это поле не указано - для текущего пользователя.
	 * Request for creating a MONETA.RU account for the user that is specified in the unitId element. If unitId is omitted, an account is created for the current user.
	 * 
 */
class CreateAccountRequest
{
	
	/**
	 * Тип счета.
	 * Значение по умолчанию равно 2 (Расширенный счет).
	 * Account type.
	 * Default value is 2 (Advanced account).
	 * 
	 *
	 * @var int
	 */
	 public $type = null;

	/**
	 * Валюта счета.
	 * Account currency.
	 * 
	 *
	 * @var string
	 */
	 public $currency = null;

	/**
	 * Название счета. Название счета должно быть уникальным среди счетов одного пользователя.
	 * Account alias. Specify a unique name among the other accounts of the specified user.
	 * 
	 *
	 * @var string
	 */
	 public $alias = null;

	/**
	 * Тип платежного пароля. По умолчанию равен STATIC.
	 * Payment password type. Default value is STATIC.
	 * 
	 *
	 * @var string
	 */
	 public $paymentPasswordType = null;

	/**
	 * Платежный пароль. Минимальная длина - 5 символов. Это поле используется, если тип платежного пароля равен STATIC.
	 * Payment password. Minimum length is 5 symbols. Use this element, when paymentPasswordType is STATIC.
	 * 
	 *
	 * @var string
	 */
	 public $paymentPassword = null;

	/**
	 * Включить срок действия платежного пароля. Срок действия пароля равен одному году. Это поле используется, если тип платежного пароля равен STATIC.
	 * Payment password expiration date. Use this element, when paymentPasswordType is STATIC.
	 * 
	 *
	 * @var boolean
	 */
	 public $paymentPasswordExpirationDate = null;

	/**
	 * Пользователь, которому будет принадлежать данный счет. Если это поле не задано, то счет создается для текущего пользователя.
	 * The owner of the account. If you omit this element, the account will belong to the current user.
	 * 
	 *
	 * @var long
	 */
	 public $unitId = null;

	/**
	 * URL после списания средств.
	 * Specifies the URL of the script that MONETA.RU calls after debiting the payer's account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulDebitUrl = null;

	/**
	 * URL после зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls after crediting the payee's account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulCreditUrl = null;

	/**
	 * Код проверки целостности данных.
	 * Signature that MONETA.RU uses to verify data integrity submitted from a payment form.
	 * 
	 *
	 * @var string
	 */
	 public $signature = null;

	/**
	 * Если баланс счета меньше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the minimum balance threshold for an account. If the balance drops below the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $lowBalanceThreshold = null;

	/**
	 * Если баланс счета больше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the maximum balance threshold for an account. If the balance exceeds the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $highBalanceThreshold = null;

	/**
	 * Счет-прототип с которого берутся свойства "по умолчанию".
	 * Prototype account number. Settings from this account are used as default values.
	 * 
	 *
	 * @var long
	 */
	 public $prototypeAccountId = null;

	/**
	 * URL после отмены списания средств.
	 * Specifies the URL of the script that MONETA.RU calls if a debit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledDebitUrl = null;

	/**
	 * URL после отмены зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls if a deposit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledCreditUrl = null;

	/**
	 * URL после авторизации средств.
	 * Specifies the URL of the script that MONETA.RU calls after authorising the payer's account.
	 * 
	 *
	 * @var string
	 */
	 public $onAuthoriseUrl = null;

	/**
	 * Свойства счета.
	 * Данные представляются в виде "ключ-значение". Возможные ключи:
	 * alias. Название счета. Название счета должно быть уникальным среди счетов одного пользователя.
	 * Если необходимо Название счета (Псевдоним) сделать публичным, то в элементе attribute для поля alias следует передать элемент published со значение true.
	 * interfacetype. Тип интерфейса.
	 * 1 - MONETA.Assistant.
	 * testmode. Тестовый режим (true|false).
	 * paymentsystem_limitids. Список платежных систем.
	 * paymentsystem_unitid. Платежная система по умолчанию.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP метод для PayUrl, CheckUrl (GET | POST).
	 * issignaturemandatory. Подпись формы оплаты обязательна (true|false).
	 * redefinesettingsinurl. Можно переопределять настройки в url (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (возврат для iframe). Возможные значения: _blank, _self, _top, _parent.
	 * Account properties.
	 * Information about an account contains a list of key-value pairs. Valid keys for account are:
	 * alias. Account alias. Specify a unique name among the other accounts of the specified user.
	 * interfacetype. Interface type.
	 * 1 - MONETA.Assistant.
	 * testmode. Test mode (true|false).
	 * paymentsystem_limitids. Payment method IDs.
	 * paymentsystem_unitid. Default payment method.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP method for PayUrl, CheckUrl (GET | POST).
	 * issignaturemandatory. Mandatory payment form signature (true|false).
	 * redefinesettingsinurl. Settings can be redefined in URL (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (redirect in iframe). Available values: _blank, _self, _top, _parent.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $attribute = null;

	/**
	 * Свойства счета.
	 * Данные представляются в виде "ключ-значение". Возможные ключи:
	 * alias. Название счета. Название счета должно быть уникальным среди счетов одного пользователя.
	 * Если необходимо Название счета (Псевдоним) сделать публичным, то в элементе attribute для поля alias следует передать элемент published со значение true.
	 * interfacetype. Тип интерфейса.
	 * 1 - MONETA.Assistant.
	 * testmode. Тестовый режим (true|false).
	 * paymentsystem_limitids. Список платежных систем.
	 * paymentsystem_unitid. Платежная система по умолчанию.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP метод для PayUrl, CheckUrl (GET | POST).
	 * issignaturemandatory. Подпись формы оплаты обязательна (true|false).
	 * redefinesettingsinurl. Можно переопределять настройки в url (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (возврат для iframe). Возможные значения: _blank, _self, _top, _parent.
	 * Account properties.
	 * Information about an account contains a list of key-value pairs. Valid keys for account are:
	 * alias. Account alias. Specify a unique name among the other accounts of the specified user.
	 * interfacetype. Interface type.
	 * 1 - MONETA.Assistant.
	 * testmode. Test mode (true|false).
	 * paymentsystem_limitids. Payment method IDs.
	 * paymentsystem_unitid. Default payment method.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP method for PayUrl, CheckUrl (GET | POST).
	 * issignaturemandatory. Mandatory payment form signature (true|false).
	 * redefinesettingsinurl. Settings can be redefined in URL (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (redirect in iframe). Available values: _blank, _self, _top, _parent.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAttribute(KeyValueAttribute $item)
	{
		$this->attribute[] = $item;
	}

}
