/*
Spoiler plugin for TinyMCE 4 editor

It adds special markup that in combination with a site-side JS script
can create spoiler effect (hidden text that is shown on clik) on a web-page.
An example of a site-side script: https://jsfiddle.net/romanvm/7w9shc27/

(c) 2016, Roman Miroshnychenko <romanvm@yandex.ua>
License: LGPL <http://www.gnu.org/licenses/lgpl-3.0.en.html>
*/
tinymce.PluginManager.add('spoiler', function(editor, url)
{
	editor.contentCSS.push(url + '/css/spoiler.css');
	var spoilerCaption = editor.getParam('spoiler_caption', 'Спойлер');

	function addSpoiler()
	{
		var selection = editor.selection;
		var node = selection.getNode();
		if (node) {
			editor.undoManager.transact(function() {
				var content = selection.getContent();
				if (!content) {
					content = 'Текст';
				}
				
				selection.setContent('<div class="spoiler">' +
					'<div class="spoiler-title"><div class="spoiler-toggle show-icon">&nbsp;</div><div class="title-text">' + spoilerCaption + ' </div></div>' +
					'<div class="spoiler-content disp-n">' +
					content +
					'</div></div>');
			});
			editor.nodeChanged();
		}
	}

	function removeSpoiler()
	{
		var selection = editor.selection;
		var node = selection.getNode();
		if (node && node.className == 'spoiler')
		{
			editor.undoManager.transact(function()
			{
				var newPara = document.createElement('p');
				newPara.innerHTML = node.getElementsByClassName('spoiler-content')[0].innerHTML;
				node.parentNode.replaceChild(newPara, node);
			});
			editor.nodeChanged();
		}
	}

	editor.ui.registry.addButton('spoiler-add',
	{
		tooltip: 'Добавить спойлер',
		icon: "code",
		onAction: addSpoiler
	});
	editor.ui.registry.addMenuItem('spoiler-add',
	{
		text: 'Добавить спойлер',
		context: 'format',
		onAction: addSpoiler
	});
	editor.ui.registry.addButton('spoiler-remove',
	{
		tooltip: 'Удалить спойлер',
		icon: "code",
		onAction: removeSpoiler
	});
	editor.ui.registry.addMenuItem('spoiler-remove',
	{
		text: 'Удалить спойлер',
		context: 'format',
		onAction: removeSpoiler
	});
});