<?php
if(!is_admin()){
	show_error_page('not_adm');
}

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", page()->title);
$tpl->set("{name}", configs()->name);
$tpl->compile( 'title' );
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title'], false);
$tpl->set("{image}", page()->image);
$tpl->set("{other}", '');
$tpl->set("{token}", token());
$tpl->set("{cache}", configs()->cache);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('top.tpl');
$tpl->set("{site_name}", configs()->name);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('menu.tpl');
$tpl->compile( 'content' );
$tpl->clear();

$nav = [
	$PI->to_nav('admin', 0, 0),
	$PI->to_nav('admin_servers', 1, 0)
];
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl', 1);

$tpl->load_template('page_top.tpl');
$tpl->set("{nav}", $nav);
$tpl->compile( 'content' );
$tpl->clear();

$servers = "<option value=\"0\">Не импортировать</option>";
$STH = pdo()->query("SELECT `id`, `name`, `game` FROM `servers` WHERE `type` != '0' ORDER BY `trim`");
$STH->setFetchMode(PDO::FETCH_OBJ);
while($row = $STH->fetch()) {
	$isAllowGroups = (GameCMS\Services\ServersService::isCS16($row->game) ? 0 : 1);
	$servers .= "<option value=\"{$row->id}\" data-is-allow-groups=\"{$isAllowGroups}\" class=\"disp-b\">{$row->name}</option>";
}

$STH = pdo()->query("SELECT `mon_gap`, `mon_key`, `mon_api` FROM `config__secondary`");
$STH->setFetchMode(PDO::FETCH_OBJ);
$row = $STH->fetch();
if($row->mon_api == 1){
	$act = 'active';
	$act2 = '';
} elseif ($row->mon_api == 2) {
	$act = '';
	$act2 = 'active';
}

$games = '';
foreach((new GameCMS\Services\ServersService)->getGames() as $gameNum => $gameName) {
	$games .= "<option value=\"{$gameNum}\">{$gameName}</option>";
}

$tpl->load_template('servers.tpl');
$tpl->set("{games}", $games);
$tpl->set("{servers}", $servers);
$tpl->set("{api_active}", $act);
$tpl->set("{api_active2}", $act2);
$tpl->set("{mon_gap}", $row->mon_gap);
$tpl->set("{mon_key}", $row->mon_key);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('bottom.tpl');
$tpl->compile( 'content' );
$tpl->clear();