<?php

global $PI;


$logs = (new Logs())->getLogs();

$configSecondary = pdo()
	->query("SELECT payments_debug FROM config__secondary LIMIT 1")
	->fetch(PDO::FETCH_OBJ);

foreach($logs as $key => $value) {
	if(file_exists($value['file'])) {
		$size    = calculate_size(filesize($value['file']));
	} else {
		$size    = 0;
	}

	$logs[$key]['size']    = $size;
	$logs[$key]['header'] = $value['header'];
}

(new Page())
	->setBreadCrumbs(
		[
			$PI->to_nav('admin'),
			$PI->to_nav('admin_logs', 1)
		]
	)
	->collectPage('logs.tpl', [
		'displayPaymentsDebugLog' => $configSecondary->payments_debug
	]);
