<?php
global $PI;

if(!is_admin()){
	show_error_page('not_adm');
}

$serverId = getPageParam('server');

$adminsService = new GameCMS\Services\AdminsService();

if($serverId) {
	$server = \GameCMS\Repositories\ServerRepository::getById($serverId);
	if(empty($server)) {
		show_error_page('servers_not_configured');
	}

	$integrator = $adminsService->getIntegrator($server->type);
	if($integrator->isBlank()) {
		show_error_page('servers_not_configured');
	}
} else {
	$servers = \GameCMS\Repositories\ServerRepository::getAll();
	foreach($servers as $serverItem) {
		$integrator = $adminsService->getIntegrator($serverItem->type);
		if(!$integrator->isBlank()) {
			$server = $serverItem;
			break;
		}
	}
}

if(empty($server)) {
	show_error_page('servers_not_configured');
}

$binds = [0, 0, 0];
if(isset($server->id)) {
	$binds = explode(';', $server->binds);
}

tpl()->load_template('elements/title.tpl');
tpl()->set("{title}", page()->title);
tpl()->set("{name}", configs()->name);
tpl()->compile( 'title' );
tpl()->clear();

tpl()->load_template('head.tpl');
tpl()->set("{title}", tpl()->result['title'], false);
tpl()->set("{image}", page()->image);
tpl()->set("{other}", getLibAssets('timepicker'));
tpl()->set("{token}", token());
tpl()->set("{cache}", configs()->cache);
tpl()->compile( 'content' );
tpl()->clear();

tpl()->load_template('top.tpl');
tpl()->set("{site_name}", configs()->name);
tpl()->compile( 'content' );
tpl()->clear();

tpl()->load_template('menu.tpl');
tpl()->compile( 'content' );
tpl()->clear();

$nav = [
	$PI->to_nav('admin', 0, 0),
	$PI->to_nav('admin_admins', 1, 0)
];
$nav = tpl()->get_nav($nav, 'elements/nav_li.tpl', 1);

tpl()->load_template('page_top.tpl');
tpl()->set("{nav}", $nav);
tpl()->compile( 'content' );
tpl()->clear();

$servers = '';
foreach(GameCMS\Repositories\ServerRepository::getAll() as $serverItem) {
	if(!$adminsService->getIntegrator($serverItem->type)->isBlank()) {
		if($serverItem->id == $server->id) {
			$servers .= "<option value=\"{$serverItem->id}\" title=\"{$serverItem->type}\" selected>{$serverItem->name}</option>";
		} else {
			$servers .= "<option value=\"{$serverItem->id}\" title=\"{$serverItem->type}\">{$serverItem->name}</option>";
		}
	}
}

tpl()->load_template('admins.tpl');
tpl()->set("{servers}", $servers);
tpl()->set("{server}", $server->id);
tpl()->set("{server_type}", $server->type);
tpl()->compile( 'content' );
tpl()->clear();

tpl()->load_template('bottom.tpl');
tpl()->compile( 'content' );
tpl()->clear();