<?php

namespace GameCMS\Utils;

class Lock
{
    private $lockFile;

    public function __construct($name)
    {
        $name = preg_replace('/[^a-zA-Z0-9\-]/ui', '', $name);

        if (empty($name)) {
            $name = 'empty';
        }

        $this->lockFile = fopen(getTempPath().'/'.$name.'.lock', 'w+');

        if (false === $this->lockFile) {
            log_error("lock: Не удалось создать файл для лока {$name}");
        }
    }

    public function lock($timeout = 0): bool
    {
        if (!$this->lockFile) {
            return false;
        }

        while ($timeout > 0) {
            if (flock($this->lockFile, LOCK_EX | LOCK_NB)) {
                return true;
            }

            sleep(1);
            --$timeout;
        }

        return flock($this->lockFile, LOCK_EX | LOCK_NB);
    }

    public function unLock(): void
    {
        if ($this->lockFile) {
            flock($this->lockFile, LOCK_UN);
        }
    }

    public function close()
    {
        if ($this->lockFile) {
            fclose($this->lockFile);
        }
    }
}
