<?php

namespace GameCMS\Services;

use GameCMS\Integrations\Integrations;

class ServersService
{
    public const CS_1_6 = 'Counter-Strike: 1.6';
    public const CS_S = 'Counter-Strike: Source';
    public const CS_GO = 'Counter-Strike: Global Offensive';
    public const CS_2 = 'Counter-Strike: 2';

    private array $games = [
        0 => self::CS_1_6,
        1 => self::CS_S,
        2 => self::CS_GO,
        22 => self::CS_2,
        3 => 'Alien Swarm',
        4 => 'CSPromod',
        5 => 'Day of Defeat: Source',
        6 => 'Dystopia',
        7 => 'E.Y.E: Divine Cybermancy',
        8 => 'Fortress Forever',
        9 => "Garry's Mod",
        10 => 'Half-Life 2 Deathmatch',
        11 => 'Half-Life 2 Capture the Flag',
        12 => 'Hidden: Source',
        13 => 'Insurgency: Source',
        14 => 'Left 4 Dead 2',
        15 => 'Left 4 Dead',
        16 => 'Nuclear Dawn',
        17 => 'Perfect Dark: Source',
        18 => 'Pirates Vikings and Knights II',
        19 => 'Team Fortress 2',
        20 => 'The Ship',
        21 => 'Zombie Panic',
    ];

    public function getGame($gameNum): string
    {
        return array_key_exists($gameNum, $this->games) ? $this->games[$gameNum] : '';
    }

    public function getGames(): array
    {
        return $this->games;
    }

    public static function isCS16(string $game): bool
    {
        return self::CS_1_6 === $game;
    }

    public static function isCSS(string $game): bool
    {
        return self::CS_S === $game;
    }

    public static function isCSGO(string $game): bool
    {
        return self::CS_GO === $game;
    }

    public static function isCS2(string $game): bool
    {
        return self::CS_2 === $game;
    }

    public function isValidIntegrationType(int $type): bool
    {
        return in_array($type, [
            Integrations::BLANK,
            Integrations::USERS_FILE,
            Integrations::AMXBANS,
            Integrations::AMXBANS_WITH_USERS_FILE,
            Integrations::SOURCEBANS,
            Integrations::AMXBANS_WITH_GAMECMS_API,
            Integrations::IKS,
        ]);
    }
}
