<?php

namespace GameCMS\Services\HeadApi;

use GameCMS\Clients\Curl;
use GameCMS\Common\Error;

class UpdatesService
{
    private Curl $client;

    public function __construct(Curl $client)
    {
        $this->client = $client;
    }

    /**
     * @return array{version: ?float, description: ?string, ?Error}
     */
    public function getUpdateInfo($version): array
    {
        $response = $this->client->post('http://www.gamecms-alt.ru/api/check_version.php', [
            'version' => $version,
            'action' => 'info',
        ]);

        $response = json_decode($response, true);

        if ($this->client->isHttpError() || $response['status'] != "success") {
            if (isset($response['detail'])) {
                $error = $response['detail'];
            } else {
                $error = 'Произошла ошибка';
            }

            return [null, null, null, error($error)];
        }
        
        return [$response['latestVersion'], $response['newVersion'], $response['description'], null];
    }

    /**
     * @return array{?string, ?string, ?Error}
     */
    public function getInstaller($version): array
    {
        $response = $this->client->post('http://www.gamecms-alt.ru/api/check_version.php', [
            'version' => $version,
            'action' => 'update',
        ]);

        if ($this->client->isHttpError() || $response['status'] == "error") {
            $response = json_decode($response, true);

            if (isset($response['detail'])) {
                $error = $response['detail'];
            } else {
                $error = 'Произошла ошибка';
            }

            return [null, error($error)];
        }

        return [$response, null];
    }
}
