<?php

namespace GameCMS\Services\HeadApi\Models;

class VersionsInfo
{
    private VersionInfo $current;
    private ?VersionInfo $next;
    private ?VersionInfo $previous;

    public function __construct(VersionInfo $current, ?VersionInfo $next = null, ?VersionInfo $previous = null)
    {
        $this->current = $current;
        $this->next = $next;
        $this->previous = $previous;
    }

    public static function fromArray(array $data): VersionsInfo
    {
        $current = VersionInfo::fromArray($data['current']);
        $next = null;
        $previous = null;

        if (isset($data['next'])) {
            $next = VersionInfo::fromArray($data['next']);
        }

        if (isset($data['previous'])) {
            $previous = VersionInfo::fromArray($data['previous']);
        }

        return new VersionsInfo($current, $next, $previous);
    }

    public function getCurrentVersion(): VersionInfo
    {
        return $this->current;
    }

    public function getNextVersion(): ?VersionInfo
    {
        return $this->next;
    }

    public function isHasNextVersion(): bool
    {
        return null !== $this->next;
    }

    public function getPreviousVersion(): ?VersionInfo
    {
        return $this->previous;
    }

    public function isHasPreviousVersion(): bool
    {
        return null !== $this->previous;
    }
}
