<?php

namespace GameCMS\Services\HeadApi\Models;

class Versions
{
    /**
     * @var float[]
     */
    private array $versions;

    /**
     * @param float[] $versions
     */
    public function __construct(array $versions)
    {
        $this->versions = $versions;
    }

    public function isLastVersion(float $version): bool
    {
        return $version === end($this->versions);
    }

    public function isFirstVersion(float $version): bool
    {
        return $version === $this->versions[0];
    }

    public function isBetaVersion(float $version): bool
    {
        return !in_array($version, $this->versions);
    }

    public function getNextVersion(float $version): ?float
    {
        if ($this->isLastVersion($version)) {
            return null;
        }

        for ($i = count($this->versions) - 1; $i >= 0; --$i) {
            if ($version === $this->versions[$i]) {
                return $this->versions[$i + 1];
            }
        }

        return null;
    }

    public function getPreviousVersion(float $version): ?float
    {
        if ($this->isFirstVersion($version)) {
            return null;
        }

        for ($i = 1; $i < count($this->versions); ++$i) {
            if ($version === $this->versions[$i]) {
                return $this->versions[$i - 1];
            }
        }

        return null;
    }
}
