<?php

namespace GameCMS\Services\HeadApi\Models;

class VersionInfo
{
    private float $version;
    private string $description;
    private bool $beta;

    public function __construct(float $version, string $description, bool $beta = false)
    {
        $this->version = $version;
        $this->description = $description;
        $this->beta = $beta;
    }

    public function getVersion(): float
    {
        return $this->version;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function isBeta(): bool
    {
        return $this->beta;
    }

    public static function fromArray(array $data): VersionInfo
    {
        return new VersionInfo($data['version'], $data['description'], $data['beta']);
    }
}
