<?php

namespace GameCMS\Services;

use GameCMS\Integrations\Bans\AmxBansIntegration;
use GameCMS\Integrations\Bans\BanSystemIntegration;
use GameCMS\Integrations\Bans\BlankIntegration;
use GameCMS\Integrations\Bans\IksIntegration;
use GameCMS\Integrations\Bans\SourceBansIntegration;
use GameCMS\Integrations\Integrations;

class BansService
{
    public function getIntegrator(int $integration): ?BanSystemIntegration
    {
        switch ($integration) {
            case Integrations::AMXBANS_WITH_USERS_FILE:
            case Integrations::AMXBANS:
            case Integrations::AMXBANS_WITH_GAMECMS_API:
                return new AmxBansIntegration();

            case Integrations::SOURCEBANS:
                return new SourceBansIntegration();

            case Integrations::IKS:
                return new IksIntegration();

            case Integrations::USERS_FILE:
            case Integrations::BLANK:
            default:
                return new BlankIntegration();
        }
    }
}
