<?php

namespace GameCMS\Integrations\Admins;

use GameCMS\Common\Error;
use GameCMS\Models\Admin;
use GameCMS\Models\Server;

interface AdminSystemIntegration
{
    public function isBlank(): bool;

    /**
     * @return array{?mixed, ?Error}
     */
    public function getStorageConnection(Server $server): array;

    /**
     * @param mixed $connection
     *
     * @return array{bool, ?Error}
     */
    public function exportAdmin(string $adminFindName, $connection, Server $server, Admin $admin): array;

    /**
     * @param mixed $connection
     *
     * @return array{bool, ?Error}
     */
    public function removeAdmin(string $adminFindName, $connection, Server $server): array;

    /**
     * @param mixed $connection
     *
     * @return array{bool, ?Error}
     */
    public function importAdmins($connection, Server $server): array;

    /**
     * @param Admin[] $admins
     * @param mixed   $connection
     *
     * @return array{bool, ?Error}
     */
    public function exportAdmins($connection, Server $server, array $admins): array;

    public function notyServer(Server $server): void;

    public function isImmunityUsing(): bool;

    public function isGroupsUsing(): bool;

    public function isNickWithPasswordAuthAllowed(): bool;

    public function isSteamIdAuthAllowed(): bool;

    public function isSteamIdWithPasswordAuthAllowed(): bool;
}
