<?php

namespace GameCMS\Configs;

/** @phpstan-consistent-constructor */
abstract class Base
{
    protected const TABLE = '';

    private ?\PDO $connection;

    private function __construct()
    {
        $table = static::TABLE;

        $pdo = pdo();

        if ($pdo) {
            $this->connection = $pdo;

            $configs = $this->connection
                ->query("SELECT * FROM {$table}")
                ->fetchAll()[0];

            foreach ($configs as $key => $value) {
                $this->{$key} = $value;
            }
        }
    }

    public function __get(string $key)
    {
        return isset($this->{$key}) ? $this->{$key} : null;
    }

    public function __set($key, $value)
    {
        if (isset($this->{$key})) {
            $this->{$key} = $value;
        }
    }

    public static function getInstance()
    {
        if (null === static::$instance) { // @phpstan-ignore-line
            static::$instance = new static();
        }

        return static::$instance;
    }

    public function update(string $key, $value)
    {
        $table = static::TABLE;

        $this->{$key} = $value;

        $this->connection
            ->prepare("UPDATE {$table} SET `{$key}` = :value LIMIT 1")
            ->execute(['value' => $value]);
    }
}
