<?php

use GameCMS\Services\HeadApi\Client;
use GameCMS\Services\HeadApi\UpdatesService;

include_once __DIR__.'/../inc/start.php';

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken() || !is_admin()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

if (isset($_POST['install_update'])) {
    ignore_user_abort(1);
    set_time_limit(0);

    set_error_handler(
        function ($errno, $errstr) {
            throw new Exception($errstr, $errno);
        }
    );

    try {
        $updateParams = pdo()->query('SELECT update_params FROM config__secondary LIMIT 1')->fetchColumn();
        $updateParams = json_decode($updateParams, true);

        $version = $updateParams['version'];
        $link = $updateParams['link'];

        global $host;

        [$client] = Client::get(10);
        $updates = new UpdatesService($client);

        if (!$updates->isInstallerUrlCorrect($link, $host)) {
            throw new Exception('Некорректная ссылка на обновление');
        }

        $updatePath = __DIR__.'/../modules/updates/'.$version.'/';
        $updateInstallersPath = __DIR__.'/../modules/updates/'.$version.'/installer/';

        $startInstaller = $updateInstallersPath.'first_installer.php';
        $finishInstaller = $updateInstallersPath.'second_installer.php';
        $sqlInstaller = $updateInstallersPath.'base.sql';

        write_log('Начало установки обновления '.$version);

        if (file_exists($updatePath)) {
            removeDirectory($updatePath);
        }

        if (!mkdir($updatePath, 0777)) {
            throw new Exception('Не удалось создать директорию для обновления');
        }

        $linkParts = explode('/', $link);
        $updateArchive = end($linkParts);

        $updateFile = $updatePath.$updateArchive;

        [$installer, $error] = $updates->downloadInstaller($link);
        if ($error) {
            throw new Exception((string) $error);
        }

        file_put_contents($updateFile, $installer);

        $archive = new PclZip($updateFile);
        $result = $archive->extract(PCLZIP_OPT_PATH, $updatePath);

        if (file_exists($startInstaller)) {
            include_once $startInstaller;
        }

        if (file_exists($sqlInstaller)) {
            $sql = trim(file_get_contents($sqlInstaller));

            if (!empty($sql)) {
                pdo()->exec('START TRANSACTION; '.$sql.' COMMIT;');
            }
        }

        copy_files($updatePath.'files/', __DIR__.'/../');

        if (file_exists($finishInstaller)) {
            include_once $finishInstaller;
        }

        unlink($updateFile);
        removeDirectory($updatePath);
    } catch (Exception $exception) {
        error_log(
            'Ошибка при установке обновления '.$version.': '
            .$exception->getMessage()
        );

        exit(json_encode(['status' => 2, 'message' => $exception->getMessage()]));
    }

    tpl()->dell_cache();

    pdo()
        ->prepare('UPDATE config SET cache=:cache LIMIT 1')
        ->execute([':cache' => configs()->cache + 1]);

    pdo()
        ->prepare('UPDATE config__secondary SET version=:version, update_params=:update_params LIMIT 1')
        ->execute([':version' => $version, ':update_params' => '']);

    write_log('Установка обновления '.$version.' завершена');

    exit(json_encode(['status' => 1]));
}
