<?php

include_once __DIR__.'/../inc/start.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

if (isset($_POST['chat_first_messages'])) {
    $i = 0;
    $users_groups = users_groups();

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $STH = $pdo->query('SELECT chat.*, users.login, users.avatar, users.rights FROM chat LEFT JOIN users ON chat.user_id = users.id ORDER BY chat.id DESC LIMIT 50');
    $STH->execute();
    $row = $STH->fetchAll();
    $count = count($row);
    if (0 == $count) {
        exit('<p class="t-c">Сообщений нет</p>');
    }
    for ($i = $count - 1; $i >= 0; --$i) {
        $date = expand_date($row[$i]['message_date'], 8);
        $tpl->load_template('elements/chat_message.tpl');
        $tpl->set('{id}', $row[$i]['id']);
        $tpl->set('{user_id}', $row[$i]['user_id']);
        $tpl->set('{login}', $row[$i]['login']);
        $tpl->set('{avatar}', $full_site_host.$row[$i]['avatar']);
        $tpl->set('{date_full}', $date['full']);
        $tpl->set('{date_short}', $date['short']);
        $tpl->set('{text}', $row[$i]['message_text']);
        $tpl->set('{gp_name}', $users_groups[$row[$i]['rights']]['name']);
        $tpl->set('{gp_color}', $users_groups[$row[$i]['rights']]['color']);
        $tpl->set(
            '{gp_rights}',
            $users_groups[
            (array_key_exists('rights', $_SESSION))
                ? $_SESSION['rights']
                : 0
            ]['rights']
        );
        $tpl->compile('chat');
        $tpl->clear();
    }
    $tpl->show($tpl->result['chat']);
    $tpl->global_clear();

    exit('<script>$("#last_mess").val('.$row['0']['id'].');</script>');
}
if (isset($_POST['chat_send_message'])) {
    if (!is_auth()) {
        exit(json_encode(['status' => '2']));
    }

    $message_text = check($_POST['message_text'], null);

    if (empty($message_text)) {
        exit(json_encode(['status' => '2']));
    }

    include_once '../inc/protect.php';

    $STH = $pdo->prepare('SELECT `rights` FROM `users` WHERE `id`=:id LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $_SESSION['id']]);
    $row = $STH->fetch();

    $users_groups = users_groups();
    if (is_worthy('z', $row->rights) || is_worthy('x', $row->rights)) {
        exit(json_encode(['status' => '2']));
    }

    $message_text = find_img_mp3($message_text, $_SESSION['id']);
    $STH = $pdo->prepare('INSERT INTO `chat` (`user_id`,`message_text`,`message_date`) values (:user_id, :message_text, :message_date)');
    if ('1' == $STH->execute([':user_id' => $_SESSION['id'], ':message_text' => $message_text, ':message_date' => date('Y-m-d H:i:s')])) {
        up_online();

        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['chat_load_messages'])) {
    $load_val = check($_POST['load_val'], 'int');
    if (empty($load_val)) {
        exit('2');
    }

    $start = $load_val * 50;
    $end = 50;
    $users_groups = users_groups();
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $STH = $pdo->query('SELECT chat.*, users.login, users.avatar, users.rights FROM chat LEFT JOIN users ON chat.user_id = users.id ORDER BY chat.id DESC LIMIT '.$start.', '.$end);
    $STH->execute();
    $row = $STH->fetchAll();
    $count = count($row);
    if ($count > 0) {
        for ($i = $count - 1; $i >= 0; --$i) {
            $date = expand_date($row[$i]['message_date'], 8);
            $tpl->load_template('elements/chat_message.tpl');
            $tpl->set('{id}', $row[$i]['id']);
            $tpl->set('{user_id}', $row[$i]['user_id']);
            $tpl->set('{login}', $row[$i]['login']);
            $tpl->set('{avatar}', $full_site_host.$row[$i]['avatar']);
            $tpl->set('{date_full}', $date['full']);
            $tpl->set('{date_short}', $date['short']);
            $tpl->set('{text}', $row[$i]['message_text']);
            $tpl->set('{gp_name}', $users_groups[$row[$i]['rights']]['name']);
            $tpl->set('{gp_color}', $users_groups[$row[$i]['rights']]['color']);
            $tpl->set(
                '{gp_rights}',
                $users_groups[
                    (array_key_exists('rights', $_SESSION))
                    ? $_SESSION['rights']
                    : 0
                ]['rights']
            );
            $tpl->compile('chat');
            $tpl->clear();
        }
        $tpl->show($tpl->result['chat']);
        $tpl->global_clear();
    }
    if (50 != $count) {
        exit('<script>$("#load_val").val(0);</script>');
    }

    exit;
}
if (isset($_POST['drop_img'])) {
    if (empty($_SESSION['id'])) {
        exit(json_encode(['status' => '2', 'data' => 'Авторизуйтесь, чтобы отправлять сообщения!']));
    }

    include_once '../inc/protect.php';

    $STH = $pdo->prepare('SELECT `rights` FROM `users` WHERE `id`=:id LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $_SESSION['id']]);
    $row = $STH->fetch();

    $users_groups = users_groups();
    if (is_worthy('z', $row->rights) || is_worthy('x', $row->rights)) {
        exit(json_encode(['status' => '2', 'data' => 'Недостаточно прав!']));
    }

    if (empty($_FILES['file']['name'])) {
        exit(json_encode(['status' => '2', 'data' => 'Пустой файл']));
    }
    $path = 'files/filemanager/'.$_SESSION['id'].'/';
    $date = time();
    $message_text = '';

    if (!file_exists($_SERVER['DOCUMENT_ROOT'].'/'.$path)) {
        mkdir($_SERVER['DOCUMENT_ROOT'].'/'.$path, 0777);
    }
    if (!file_exists($_SERVER['DOCUMENT_ROOT'].'/files/thumbs/'.$_SESSION['id'].'/')) {
        mkdir($_SERVER['DOCUMENT_ROOT'].'/files/thumbs/'.$_SESSION['id'].'/', 0777);
    }

    if (if_img($_FILES['file']['name']) || if_mp3($_FILES['file']['name'])) {
        $file_type = substr($_FILES['file']['name'], strrpos($_FILES['file']['name'], '.') + 1);
        $source = $_FILES['file']['tmp_name'];
        $file = $path.$date.$_SESSION['id'].'.'.$file_type;
        $target = '../'.$file;
        if (!move_uploaded_file($source, $target)) {
            exit(json_encode(['status' => '2', 'data' => 'Ошибка загрузки файла!']));
        }
    } else {
        exit(json_encode(['status' => '2', 'data' => 'Файл должен являться изображением в <br> формате JPG,GIF или PNG, либо <br> аудизаписью в формате MP3']));
    }
    if (if_img($_FILES['file']['name'])) {
        $message_text = '<a href="'.$full_site_host.$file.'" class="thumbnail" data-lightbox="'.$_SESSION['id'].'"><img src="'.$full_site_host.$file.'" class="thumbnail-img"></a>';
    } elseif (if_mp3($_FILES['file']['name'])) {
        $message_text = '<audio src="'.$full_site_host.$file.'" controls="controls">Аудио файл: '.$full_site_host.$file.'</audio>';
    }

    $STH = $pdo->prepare('INSERT INTO `chat` (`user_id`,`message_text`,`message_date`) values (:user_id, :message_text, :message_date)');
    if ('1' == $STH->execute([':user_id' => $_SESSION['id'], ':message_text' => $message_text, ':message_date' => date('Y-m-d H:i:s')])) {
        up_online();

        exit(json_encode(['status' => '1']));
    }

    exit(json_encode(['status' => '2']));
}
if (isset($_POST['get_messages'])) {
    $last_mess = check($_POST['last_mess'], 'int');
    if (empty($last_mess)) {
        exit('2');
    }
    $users_groups = users_groups();

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $STH = pdo()->prepare('SELECT MAX(id) as max FROM chat');
    $STH->execute();
    $row = $STH->fetch(PDO::FETCH_ASSOC);
    if ($last_mess < $row['max']) {
        $last_mess_new = $row['max'];
        $STH = pdo()->query("SELECT chat.*, users.login, users.avatar, users.rights FROM chat LEFT JOIN users ON chat.user_id = users.id WHERE chat.id > '{$last_mess}' ORDER BY chat.id DESC");
        $STH->execute();
        $row = $STH->fetchAll();
        $count = count($row);
        for ($i = $count - 1; $i >= 0; --$i) {
            $date = expand_date($row[$i]['message_date'], 8);
            $tpl->load_template('elements/chat_message.tpl');
            $tpl->set('{id}', $row[$i]['id']);
            $tpl->set('{user_id}', $row[$i]['user_id']);
            $tpl->set('{login}', $row[$i]['login']);
            $tpl->set('{avatar}', $full_site_host.$row[$i]['avatar']);
            $tpl->set('{date_full}', $date['full']);
            $tpl->set('{date_short}', $date['short']);
            $tpl->set('{text}', $row[$i]['message_text']);
            $tpl->set('{gp_name}', $users_groups[$row[$i]['rights']]['name']);
            $tpl->set('{gp_color}', $users_groups[$row[$i]['rights']]['color']);
            $tpl->set(
                '{gp_rights}',
                $users_groups[
                (array_key_exists('rights', $_SESSION))
                    ? $_SESSION['rights']
                    : 0
                ]['rights']
            );
            $tpl->compile('chat');
            $tpl->clear();
        }
        $tpl->show($tpl->result['chat']);
        $tpl->global_clear();

        exit('<script>$("#last_mess").val('.$last_mess_new.');</script>');
    }

    exit('2');
}
if (isset($_POST['get_smiles'])) {
    if (empty($_SESSION['id'])) {
        exit('<script>reset_page();</script>');
    }
    if (empty($_POST['type'])) {
        $type = null;
    } else {
        $type = check($_POST['type'], null);
    }

    if (1 == $_SESSION['stickers']) {
        $price = '';
        $load_stickers = 1;
    } else {
        $STH = pdo()->query('SELECT price4 FROM config__prices LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        $price = $row->price4;
        $load_stickers = 0;
    }

    $stickers = '';
    $stickers_panel = '';
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';
    $tpl->load_template('/elements/smiles.tpl');
    $tpl->set('{price}', $price);
    if (1 == $type) {
        $tpl->set('{only_smiles}', 1);
    } else {
        $tpl->set('{only_smiles}', '');
        if (1 == $load_stickers) {
            $STH = pdo()->query('SELECT * FROM `stickers`');
            $STH->execute();
            $row = $STH->fetchAll();
            $count = count($row);
            $stickers_panel .= '<div class="btn-group smiles_panel" role="group">
			<a onclick="open_sticker(\'gcms_smiles\');" class="smilebtn"><img src="../files/smiles/smile.png?v={cache}"></a>';

            for ($i = 0; $i < $count; ++$i) {
                $name_translit = translit($row[$i]['name']);
                $dir = '../files/stickers/'.$name_translit;
                if (!file_exists($dir)) {
                    continue;
                }

                $stickers .= '<div class="smiles_box disp-n" id="'.$name_translit.'">';
                $files = scandir($dir, 1);
                $count2 = count($files);
                if ($count2 > 2) {
                    $stickers_panel .= '<a onclick="open_sticker(\''.$name_translit.'\');" class="smilebtn"><img src="../files/stickers/'.$name_translit.'/'.$files[$count2 - 3].'?v={cache}"></a>';
                }
                for ($j = $count2 - 1; $j > -1; --$j) {
                    $exp = explode('.', $files[$j]);
                    $exp = end($exp);
                    if (0 == strnatcasecmp($exp, 'png') or 0 == strnatcasecmp($exp, 'jpg')) {
                        $stickers .= '<img onclick="set_sticker(this);" class="sticker" src="../files/stickers/'.$name_translit.'/'.$files[$j].'?v={cache}">';
                    }
                }
                $stickers .= '</div>';
            }
            $stickers_panel .= '</div>';
        }
    }
    $tpl->set('{stickers}', $stickers);
    $tpl->set('{stickers_panel}', $stickers_panel);
    $tpl->compile('smiles');
    $tpl->clear();
    $tpl->show($tpl->result['smiles']);
    $tpl->global_clear();

    exit;
}
